pro cleanup_componentvis
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Removes all oyster.componentvis directories accumulated over time.
;
answer=''
read,answer,prompt='Did you run updatedb already? (y/n) '
answer=strupcase(answer)
if answer eq 'N' then begin
	print,'Please run updatedb (as root) first!'
	return
endif
;
spawn,'locate oyster.componentvis',r
index=where(strpos(r,'xdr') lt 0,count)
if count gt 0 then r=r[index] else begin
	print,'No files found.'
	return
endelse
;
print,'Directories with oyster.componentvis files (sizes in MB):'
spawn,'du -s '+strjoin(r,' ')
;
answer=''
read,answer,prompt='Delete all? (y/n) '
answer=strupcase(answer)
if answer eq 'Y' then begin
	for i=0,count-1 do spawn,'rm -rf '+r[i]
	print,'Please run updatedb now as root!'
endif
;
end
