function cohen,starid,lammda,template=template
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This function returns flux [W/cm^2/micron]
;
; Return the count rate as a function of wavelength for a given star.
; Find the closest match in class and type from a data base of spectro-
; photometric standards (Cohen), unless a template is specified, and scale
; with the blackbody flux ratio arising from the temperature mismatch, if any.
;
; Currently, scaling fluxes with Teff is disabled!
;
; Return lammda [m]
;
common StarBase,startable,notes
;
forward_function teff_star
;
; Save any existing startable
if n_elements(startable) eq 0 then get_startable,starid
table=startable
;
; Get the information for the star
index=where(startable.starid eq starid,count)
if count eq 0 then begin
	get_startable,starid
	index=0
endif
type=startable[index[0]].type
class=startable[index[0]].class
mv=startable[index[0]].mv
teff_stars
teff=startable[index[0]].teff
;
; Check if choice of template is forced...
if n_elements(template) eq 0 then template=''
if strlen(template) gt 0 then begin
	words=nameparse(template,'_')
	template=words[0]
	f=file_search(!atmospheres_dir+'cohen/'+template+'_*.tem')
	if strlen(f[0]) eq 0 then begin
		print,'***Error: template not found!'
		return,-1
	endif
	words=nameparse(f[0],'.')
	cfile=words[0]
	xfile=file_search(!atmospheres_dir+'cohen/'+cfile+'.xdr') & xfile=xfile[0]
endif else begin
; or get the stars for which spectra are available
	f=file_search(!atmospheres_dir+'cohen/*.tem') & f=specname(f)
	n=n_elements(f)
	stars=strarr(n)
	spectra=strarr(n)
	for i=0,n-1 do begin
		words=nameparse(f[i],['_','.'])
		stars[i]=words[0]
		spectra[i]=words[1]
		if n_elements(words) eq 4 then $
		spectra[i]=spectra[i]+'.'+words[2]
	endfor
	spec_parse,spectra,types,classes,t2,c2
;
; 	Find closest match in type for this class
	index=where(classes eq class,count)
	if count eq 0 then begin
		class=' class '+string(class,format='(i2)')+' ('+starid+')!'
		print,'Warning: substituting 5 (V) for unknown'+class
		class=5
		index=where(classes eq class)
	endif
;
	dt=abs(types[index]-type)
	jndex=where(dt eq min(dt)) & jndex=jndex[0]
	cfile=!atmospheres_dir+'cohen/'+stars[index[jndex]]+'_' $
				    +spectra[index[jndex]]
	xfile=file_search(!atmospheres_dir+'cohen/'+cfile+'.xdr') & xfile=xfile[0]
endelse
if strlen(xfile) eq 0 then begin
	tfile=cfile+'.tem'
	xfile=cfile+'.xdr'
	print,'Reading file: '+tfile
	lines=''
	s=dc_read_fixed(tfile,lines,format='(a80)',/col)
;	index=where(strpos(lines,'Wavelength  Irradiance') ge 0)
	index=where(strpos(lines,'Wavelength') ge 0 and $
		    strpos(lines,'Irradiance') ge 0)
	index=index[0]
	m=n_elements(lines)-index-3
	lammda=fltarr(m)
	fluxes=fltarr(m)
	for i=0,m-1 do begin
		words=nameparse(lines[index+3+i])
		lammda[i]=float(words[0]); IDL 8.4 introduced function lammda
		fluxes[i]=float(words[1])
	endfor
	if getenv('USER') eq !owner then $
		save,lammda,fluxes,filename=xfile
endif else begin
	print,'Restoring file: ',xfile
	restore,xfile
endelse
lammda=lammda*1e-6
nl=n_elements(lammda)
;
; Restore original startable, if needed
if n_elements(table) ne 0 then startable=table
;
; The following is not well tested...hence we return here!
return,fluxes	; [W/cm^2/micron]
;
; Calculate the shape correction for a mismatch in temperature and apply
f_ratio=(exp(1.439d-2/(lammda*abs(teff_star(spectra[index[jndex[0]]]))))-1) $
       /(exp(1.439d-2/(lammda*abs(teff)))-1)
fluxes=fluxes*f_ratio
;
; Check the V flux against absolute calibration of 3.75e-9 erg/cm^2/s/A
fv0=total(fluxes*johnson_v(lammda*1e9))*10^(mv/2.5)/total(johnson_v(lammda*1e9))
factor=0.375/fv0
fluxes=fluxes*factor
;
; Extend to 25 microns to include N and Q bands, using black body
lammda_nq=(findgen(230)/10+2.5)*1e-6
fluxes_nq=(3.742d-30/lammda_nq^5)/(exp(1.439d-2/(lammda_nq*abs(teff)))-1)
index=where(lammda gt 2.45e-6)
factor_nq=median(fluxes[index])/fluxes_nq[0]
lammda=[lammda,lammda_nq]
fluxes=[fluxes,fluxes_nq*factor_nq]
;
; Restore original startable, if needed
if n_elements(table) ne 0 then startable=table
;
; This is the energy (ergs) of a photon of wavelength lammda
hnu=6.6262e-27*2.997925e8/lammda
;
; Return rate/cm^2/s/nm
return,(fluxes/hnu)*1e-7
;
end
