function coherentvis,baseline,beam,scanfile,channels=channels,cohint=cohint, $
						classic=classic,delay=delay
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(scanfile) ne 0 then scanfiles=file_search(scanfile+'.??') $
			     else scanfiles=''
;
if n_elements(beam) eq 0 then beam=OutputBeam $
			 else if n_elements(scanfile) eq 0 $
			 	then get_bincounts,beam
ob=beam-1
bl=baseline-1
if n_elements(channels) eq 0 then $
	channels=channelindex[genconfig.spectrometerid[ob]]
ch=channels-1
if n_elements(cohint) eq 0 then cohint=100
if n_elements(classic) eq 0 then classic=1
;
l=genconfig.wavelength[ch,ob]
k=genconfig.fringemod[bl,ob]
if scantable[0].starid eq 'FKV0000' and genconfig.beamcombinerid eq 3 $
				    then k=k*2
;
f=fdldelay(genconfig.baselineid[bl,ob],scan=n_elements(scanfile))
;
visibility=complexarr(n_elements(ch),n_elements(f)/cohint)
delay=fltarr(n_elements(f)/cohint)
;
n=0
wrap=0
;
for i=0,n_elements(scanfiles)-1 do begin
	if strlen(scanfiles[i]) gt 0 then begin
		hds_open,scanfiles[i]
		get_bincounts,beam
		hds_close
		d=f[raw0:rawn]
	endif else d=f
;
	v=fringevis(bincounts[*,ch,*],k)
	if classic then d=fringedelay(v,l,d,fdlstamp(scan=0)/1000.d0,wrap=wrap) $
		   else d=fringedelay(v,l,d,fdlstamp(scan=0)/1000.d0,gindex,wrap=wrap)
;
	n1=(rawn-raw0+1)/cohint
	delay[n:n+n1-1]=add(d,cohint)/cohint
	visibility[*,n:n+n1-1]=add(visrotate(v,l,d),cohint,1)
	n=n+n1
endfor
;
if scantable[0].starid eq 'FKV0000' then delay=delay/2
;
return,visibility
;
end
