pro cohstrictor,cohfile,classic=classic,rawpath=rawpath
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Coherently integrates NPOI data for astrometry. Not to be used for any other
; purpose as yet. 6-way compatible version.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(classic) eq 0 then classic=1
;
hds_open,cohfile
get_sysconfig
get_scantable
fixearlydays
np=scantable.numpoint
scan_ids=scantable.scanid
numcoh=scantable.numcoh*scantable.numincoh
hds_close
;
if n_elements(rawpath) eq 0 then rp='' else rp=rawpath+'/'
stub=rp+checkdate()+'.raw.'
;
n=n_elements(scan_ids)
FOR i=0,n-1 DO BEGIN
;
rawfile=stub+string(scan_ids[i],format='(i3.3)')+'.01'
print,'Now processing ',rawfile,'...'
hds_open,rawfile,'READ',status
if status ne 0 then return
get_rawdata
hds_close
if n_elements(add(timestamp,numcoh[i])) ne np[i] then begin
	print,'***ERROR(COHSTRICTOR): bad # of samples!'
	return
endif
;
for j=0,genconfig.numoutbeam-1 do begin
;
	ch=channelindex[genconfig.spectrometerid[j]]-1
	l=genconfig.wavelength[ch,j]
;
	hds_open,rawfile,'READ',status
	get_bincounts,j+1
	hds_close
;
	v=complexarr(genconfig.numspecchan[j],genconfig.numbaseline[j],n_elements(times
	d=fltarr(genconfig.numbaseline[j],n_elements(timestamp))
	g=intarr(genconfig.numbaseline[j],n_elements(timestamp))
;
	vis=complexarr(genconfig.numspecchan[j],genconfig.numbaseline[j],np[i])
	err=vis
	del=fltarr(genconfig.numbaseline[j],np[i])
;
	for k=0,genconfig.numbaseline[j]-1 do begin
		i1=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],0,3))
		i2=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],4,3))
		i1=i1[0]
		i2=i2[0]
		if scantable[0].station(i1) ne 0 and scantable[0].station(i2) ne 0 then begin
		if genconfig.beamcombinerid eq 3 and scantable[0].starid eq 'FKV0000' $
			then kf=2 else kf=1
		v[*,k,*]=fringevis(bincounts,genconfig.fringemod[k,j]*kf)
		if classic then begin
			d[k,*]=fringedelay(v[ch,k,*],l,fdldelay(genconfig.baselineid[k,j]), $
						       fdlstamp()/1000.d0)
		endif else begin
			d[k,*]=fringedelay(v[ch,k,*],l,fdldelay(genconfig.baselineid[k,j]), $
						       fdlstamp()/1000.d0,gindex)
			g[k,*]=gindex
		endelse
		endif
	endfor
	for k=0,genconfig.numbaseline[j]-1 do begin
		i1=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],0,3))
		i2=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],4,3))
		i1=i1[0]
		i2=i2[0]
		if scantable[0].station(i1) ne 0 and scantable[0].station(i2) ne 0 then begin
		r=reform(visrotate(v[*,k,*],genconfig.wavelength[*,j],d[k,*]))
		if classic then begin
			vis[*,k,*]=add(r,numcoh[i],1)
			err[*,k,*]=complex(1,1)
			del[k,*]=add(reform(d[k,*]),numcoh[i])/numcoh[i]
		endif else begin
			for is=0,np[i]-1 do begin
				rg=r[*,is*numcoh[i]:(is+1)*numcoh[i]-1]
				gi=g[k,is*numcoh[i]:(is+1)*numcoh[i]-1]
				dg=d[k,is*numcoh[i]:(is+1)*numcoh[i]-1]
				index=where(gi gt 0,count)
				if count ge 2 then begin
					vis[*,k,is]=summe(rg[*,index],1)/count
					err[*,k,is]=complex(sqrt(avg(float(rg[*,index])^2,1) $
								-avg(float(rg[*,index]),1)^2), $
							    sqrt(avg(imaginary(rg[*,index])^2,1) $
								-avg(imaginary(rg[*,index]),1)^2))
					del[k,is]=summe(reform(dg[index]))/count
				endif else begin
					err[*,k,is]=complex(-1,-1)
					del[k,is]=summe(reform(dg))/numcoh[i]
				endelse
			endfor
		endelse
		endif
	endfor
;
	if scantable[0].starid eq 'FKV0000' then del=del/2
;
	hds_open,cohfile,'UPDATE',status
	if status ne 0 then return
	dat_find,'SCANDATA'
	dat_find,'POINTDATA'
	dat_cell,1,i+1
	dat_find,'OUTPUTBEAM'
;
	dat_cell,1,j+1
	ndim=4
	dims=[2,genconfig.numspecchan[j],genconfig.numbaseline[j],np[i]]
	data=fltarr(dims[0],dims[1],dims[2],dims[3],/nozero)
	data[0,*,*,*]=float(vis)
	data[1,*,*,*]=imaginary(vis)
	name='COMPLEXVIS'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
	name='COMPLEXVISERR'
	data[0,*,*,*]=float(err)
	data[1,*,*,*]=imaginary(err)
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
	ndim=2
	dims=[genconfig.numbaseline[j],np[i]]
	name='SOFTDELAY'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,del
	del=del*0+1
	name='SOFTDELAYERR'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
	hds_close
;
endfor
;
ENDFOR
;
end
