pro compile_bbc
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
;
; Get Batten's catalog and make copy starbase
get_bat
starbase=StarTable
bat_starids=StarTable.starid
;
; Update positions and parallaxes with Hipparcos data
StarTable.starid=bat_starids
rename_starids,'bat-hip'
read_catalogs
starbase.hic=StarTable.hic
starbase.ra=StarTable.ra
starbase.dec=StarTable.dec
starbase.pmra=StarTable.pmra
starbase.pmdec=StarTable.pmdec
starbase.px=StarTable.px
starbase.pxe=StarTable.pxe
;
; Update with data from Sky Catalogue 2000.0
; rename_starids,'bat-hdn'
; read_catalogs
;
; Save parallaxes
; px=StarTable.px
;
; Read parallaxes and photometry from auxilliary HDN indexed catalogs
; get_parallax
; get_ubvri
; get_ubv
;
; Reinstate small parallaxes with values from the Sky Catalog
; index=where(px lt 0.01,count)
; if count gt 0 then begin
; 	StarTable(index).px=px(index)
; 	StarTable(index).pxe=0.01
; endif
;
; Update starbase color indices, radial velocities, and parallaxes
; starbase.ub=StarTable.ub
; starbase.bv=StarTable.bv
; starbase.ri=StarTable.ri
; starbase.rv=StarTable.rv
; starbase.px=StarTable.px
; starbase.pxe=StarTable.pxe
; starbase.hdn=StarTable.hdn
; starbase.sao=StarTable.sao
; starbase.ads=StarTable.ads
;
; Get HDN numbers
StarTable.starid=bat_starids
rename_starids,'bat-hdn'
starbase.hdn=StarTable.hdn
;
; Get WDS numbers
StarTable.starid=bat_starids
rename_starids,'bat-wds'
starbase.wds=StarTable.wds
;
; Get FLN numbers
StarTable.starid=bat_starids
rename_starids,'bat-fln'
starbase.fln=StarTable.fln
;
; Replace StarTable with starbase
StarTable=starbase
;
; Fill in unknown data with estimates
; index=where(StarTable.type2 eq 0,count)
; if count gt 0 then StarTable(index).type2=StarTable(index).type
; if count gt 0 then StarTable(index).class2=StarTable(index).class
;
; Where class/class2=0 set to default (5=dwarf)
set_defclass
;
; Estimate semi-major axes and magnitude differences
d_stars		; Compute distance in pc from parallax
mass_stars	; Estimate primary mass from spectral type
m_binaries	; Estimate secondary mass for SB2s
mass_stars,1	; Estimate sec. mass from spectral classification
		; Deal with SB1s w/out secondary classification
a_binaries	; Estimate semi-major axis with Kepler's 3rd
; i_binaries
;
amv_stars	; Estimate abs. V from spectral types
; For unclassified secondaries, derive MV from mass assuming MS
index=where(startable.dmv eq 100 and startable.mass2 ne 0)
lum2=lum_mass(startable[index].mass2)
teff2=teff_mass(startable[index].mass2)
mv2=-2.5*alog10(lum2)+4.74-bc_teff(teff2)
startable[index].dmv=mv2-startable[index].amv
startable[index].amv=cmag(startable[index].amv,mv2)
;
; Select stars observable by NPOI
t=StarTable
i=where(t.a gt 0.001 and t.a lt 0.2 and t.dec gt -20 and t.mv lt 6.0)
StarTable=t[i]
;
; Eliminate some notorious stars
;
; Recurrent novae RS Oph
i=where(StarTable.bat ne 996)
StarTable=StarTable[i]
;
print,'Number of elements in BBC :',n_elements(StarTable)
;
end
