pro compile_bbcsouth
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
;
; Get Batten's catalog and make copy starbase
get_bat
starbase=StarTable
bat_starids=StarTable.starid
;
; Read Sky Catalogue 2000.0
rename_starids,'bat-hdn'
read_catalogs
;
; Save parallaxes
px=StarTable.px
;
; Read parallaxes and photometry from auxilliary catalogs
get_parallax
get_ubvri
get_ubv
;
; Replace the parallaxes from the Sky Catalog
index=where(px lt 0.01,count)
if count gt 0 then begin
	StarTable[index].px=px[index]
	StarTable[index].pxe=0.01
endif
;
; Update starbase color indices, radial velocities, and parallaxes
starbase.ub=StarTable.ub
starbase.bv=StarTable.bv
starbase.ri=StarTable.ri
starbase.rv=StarTable.rv
starbase.px=StarTable.px
starbase.pxe=StarTable.pxe
starbase.hdn=StarTable.hdn
starbase.sao=StarTable.sao
starbase.ads=StarTable.ads
;
; Get WDS number
rename_starids,'hdn-wds'
starbase.wds=StarTable.wds
;
; Update positions with FK5 catalog and copy to data base
StarTable.starid=bat_starids
rename_starids,'bat-fkv'
read_catalogs
starbase.fkv=StarTable.fkv
starbase.ra=StarTable.ra
starbase.dec=StarTable.dec
starbase.pmra=StarTable.pmra
starbase.pmdec=StarTable.pmdec
;
; Get FLN
StarTable.starid=bat_starids
rename_starids,'bat-fln'
starbase.fln=StarTable.fln
;
; Get star names from Bright Star Catalog
StarTable.starid=bat_starids
rename_starids,'bat-bsc'
read_catalogs
get_jhk_bsc
starbase.bsc=StarTable.bsc
starbase.mj=StarTable.mj
starbase.mh=StarTable.mh
starbase.mk=StarTable.mk
;
; Replace StarTable with starbase
StarTable=starbase
;
; Fill in unknown data with estimates
index=where(StarTable.type2 eq 0,count)
if count gt 0 then StarTable[index].type2=StarTable[index].type
if count gt 0 then StarTable[index].class2=StarTable[index].class
set_defclass
;
; Do the math
amv_stars
d_stars
mass_stars
m_binaries
i_binaries
a_binaries
;
t=StarTable
i=where(t.a gt 0.001 and t.a lt 0.2 and t.dec lt 20 and t.mk lt 4.0)
StarTable=t[i]
;
; Eliminate some notorious stars
;
; Recurrent novae RS Oph
i=where(StarTable.bat ne 996)
StarTable=StarTable[i]
;
print,'Number of elements in BBC (south) :',n_elements(StarTable)
;
end
