pro compile_bcr
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Read bad calibrator registry list calibrators.bcr (tabs), and replace
; coordinates with Simbad values as these are used by the perl scripts
; in /var/www/cgi-bin. Output file is bcr.csv for use in /var/www/html.
;
; Make sure the local file is a copy of the original /var/www/html/bcr.csv!
; (a copy of all tables and scripts exists in Public/public_html/bcr)
;
; IAU Bad Calibrator page:
; http://www.eso.org/sci/observing/tools/bcr.html
; On usg:  ssh -X w4; cd /home/web/eso/docs/2007/sci/bin/bcr/
;
common StarBase,StarTable,Notes
;
s=dc_read_fixed(!oyster_dir+'starbase/calibrators.bcr',l,/col, $
	format='(a300)')
header=l[0]
;
n=n_elements(l)
l=l[1:n-1]
n=n-1
hdn=lonarr(n)
model=strarr(n)
starid=strarr(n)
;
openw,unit,'bcr.csv',/get_lun
printf,unit,header
;
for i=0,n-1 do begin
	v=nameparse(l[i],',')
	for j=0,n_elements(v)-1 do v[j]=strtrim(v[j],2)
;	Call by coordinate
;	star=cri_simbad(v(1)+' '+v(2),t)
;	Call by HD name
	star=cri_simbad(v[0],t)
;	v(0)=star	; we need HD not HDN names on the web page
	v[1]=hms(t.ra,/simbad)
	v[2]=dms(t.dec,/simbad)
	printf,unit,strjoin(v,',')
endfor
;
free_lun,unit
;
print,'Saved to bcr.csv.'
;
end
