pro compile_cal,starids
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compiles astrophysical data for calibrators. Creates startable from
; starids or uses existing startable. The base catalog ID should be HDN,
; but is converted to CAL.
;
; The diameter are LD computed from (V-K) and V. A 'K' or 'N' is added
; to indicate whether the calibrator is for AMBER or MIDI. This, for now,
; is decided on whether or not the star has a significant 12 micron flux.
;
common StarBase,StarTable,Notes
;
if n_elements(starids) ne 0 then get_startable,starids
;
; Get program IDs from notes, if available
read_notes
for i=0,n_elements(startable)-1 do begin
	list_note,startable[i].starid,note
	list_keyword,note,'PROGRAM',value
	startable[i].reference=value
endfor
;
index=where(startable.class lt 2,count)
if count gt 0 then startable[index].class=5
;
get_jhk_hdn
diameter_vk
startable.model='LDK'
;
teff_stars
logg_stars
;
get_f12
index=where(startable.f12 gt 0,count)
if count gt 0 then startable[index].model='LDN'
;
; Compute a0, a1, and a2 fit coefficients to linear limb dark. law coeff. u
limb_stars,[450,2500],/logarithmic
;
; Replace HDN catalog identifier with CAL
s=startable.starid
strput,s,'CAL'
startable.starid=s
;
end
