pro compile_sb0
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compile single star list with V<6, px>10mas, luminosity class non-zero
;
common StarBase,StarTable,Notes
;
get_jsdc
i=where(startable.mv le 6)
startable=startable[i]
i=where(startable.px gt 10)
startable=startable[i]
t=startable
rename_starids,'hip-hdn'
read_catalogs
t.type=startable.type
t.class=startable.class
t.spectrum=startable.spectrum
i=where(t.class ne 0,n)
t=t[i]
startable=t
;
mv=startable.mv
bv=startable.bv
px=startable.px
amv=mv-(-5+5*alog10(1000./px))
teff=teff_bv(bv)
mbol=amv+bc_teff(teff)
llum=-(mbol-4.74)/2.5
ltff=alog10(teff)
;
restore,'tracks.xdr'
startable.teff=teff
startable.amv=amv
;
for i=0,n-1 do begin
	d=sqrt((logl-llum[i])^2+(logt-ltff[i])^2)
	index=where(d eq min(d))
	startable[i].mass=mass[index]
endfor
;
end
