pro compile_sb1,plots=plots
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
;
get_wds & get_leeuwen
st_wds=startable[where(startable.hic ne 0)]; two stars with HIC=0(?)
get_sb9
st_sb9=startable
;
; Assign K1, K2, and RV to WDS stars by matching the period
index=where(st_wds.hic ne 0)
jndex=whereequal(st_wds[index].hic,st_sb9.hic)
for i=0,n_elements(jndex)-1 do begin
	k=where(st_sb9.hic eq st_wds[index[jndex[i]]].hic)
	for l=0,n_elements(k)-1 do begin
	if abs(st_sb9[k[l]].p/st_wds[index[jndex[i]]].p-1) lt 0.05 then begin
	st_wds[index[jndex[i]]].k1=st_sb9[k[0]].k1
	st_wds[index[jndex[i]]].k2=st_sb9[k[0]].k2
	st_wds[index[jndex[i]]].rv=st_sb9[k[0]].rv
	endif
	endfor
endfor
;
index=where(st_wds.hdn ne 0)
jndex=whereequal(st_wds[index].hdn,st_sb9.hdn)
for i=0,n_elements(jndex)-1 do begin
	k=where(st_sb9.hdn eq st_wds[index[jndex[i]]].hdn)
	for l=0,n_elements(k)-1 do begin
	if abs(st_sb9[k[l]].p/st_wds[index[jndex[i]]].p-1) lt 0.05 then begin
	st_wds[index[jndex[i]]].k1=st_sb9[k[0]].k1
	st_wds[index[jndex[i]]].k2=st_sb9[k[0]].k2
	st_wds[index[jndex[i]]].rv=st_sb9[k[0]].rv
	endif
	endfor
endfor
;
; Fix some issues
index=where(st_wds.hic eq 2912)
st_wds[index].k2=0	; Pi And: secondary curve bad
;
index=where(st_wds.k1 ne 0 and st_wds.k2 eq 0)
st_wds=st_wds[index]
;
ustars=unique(st_wds.starid,ui)
for i=0,n_elements(ustars)-1 do begin
	index=where(st_wds.starid eq ustars[i],count)
	if count ge 2 then begin
		a=medianve(st_wds[index].a,ae)
		p=medianve(st_wds[index].p,pe)
		if ae/a le 0.05 and pe/p le 0.05 then begin
			st_wds[index].a=a
			st_wds[index].p=p
		endif else begin
			st_wds[index].k1=0
			if ae/a gt 0.05 or pe/p gt 0.05 then begin
				print,ustars[i],st_wds[index].a*1000
				print,ustars[i],st_wds[index].p
			endif
		endelse
	endif
endfor
index=where(st_wds.k1 ne 0)
st_wds=st_wds[index]
ustars=unique(st_wds.starid,ui)
startable=st_wds[ui]
print,'Total number of binaries:',n_elements(startable)
;
; Fix some catalog errors
i=where(startable.hic eq 11767)
startable[i].spectrum='F8II+F0V'
i=where(startable.hic eq 21476)
startable[i].spectrum='G8III'
i=where(startable.hic eq 105269)
startable[i].spectrum='F1II+B7V'
spec_parse,startable.spectrum,type,class,type2,class2
startable.type=type
startable.class=class
startable.type2=type2
startable.class2=class2
;
if n_elements(plots) eq 0 then plots=0
if not plots then return
!p.charthick=2.0
!p.charsize=2.0
!p.thick=2.0
!x.thick=2.0
!y.thick=2.0
if !d.name ne 'PS' then !p.multi=[0,2,2] else !p.multi=0
if !d.name eq 'PS' then device,filename='parallax.eps'
!x.title='Hipparcos parallax [mas]'
histograph,startable.px*1000,bin=5,max=100
if !d.name eq 'PS' then device,/close
if !d.name eq 'PS' then device,filename='period.eps'
!x.title='log(Period/d)'
histograph,alog10(startable.p),binsize=0.2
vmed=medianve(alog10(startable.p),verr)
print,'Median period and error:',vmed,verr
if !d.name eq 'PS' then device,/close
if !d.name eq 'PS' then device,filename='semiaxis.eps'
!x.title='Semi-major axis [mas]'
histograph,startable.a*1000,min=0,max=50,bin=5
if !d.name eq 'PS' then device,/close
if !d.name eq 'PS' then device,filename='magnitude.eps'
!x.title='V magnitude'
histograph,startable.mv,min=-2,max=10,bin=0.5
vmed=medianve(startable.mv,verr)
print,'Median magnitude and error:',vmed,verr
if !d.name eq 'PS' then device,/close
;
end
