pro compile_sb2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
;
; Get Batten's catalog and make copy starbase
get_bat
starbase=StarTable
bat_starids=StarTable.starid
;
; Read Sky Catalogue 2000.0
rename_starids,'bat-hdn'
read_catalogs
;
; Save parallaxes
px=StarTable.px
;
; Read parallaxes and photometry from auxilliary catalogs
get_parallax
get_ubvri
get_ubv
;
; Replace the parallaxes from the Sky Catalog
index=where(px lt 0.01,count)
if count gt 0 then begin
	StarTable[index].px=px[index]
	StarTable[index].pxe=0.01
endif
;
; Update starbase color indices, radial velocities, and parallaxes
starbase.ub=StarTable.ub
starbase.bv=StarTable.bv
starbase.ri=StarTable.ri
starbase.rv=StarTable.rv
starbase.px=StarTable.px
starbase.pxe=StarTable.pxe
starbase.hdn=StarTable.hdn
starbase.sao=StarTable.sao
starbase.ads=StarTable.ads
;
; Get positions from SAO catalog
rename_starids,'hdn-sao'
read_catalogs
;
; Get WDS number
rename_starids,'sao-wds'
starbase.wds=StarTable.wds
;
; Update positions with FK5 catalog and copy to data base
StarTable.starid=bat_starids
rename_starids,'bat-fkv'
read_catalogs
starbase.fkv=StarTable.fkv
starbase.ra=StarTable.ra
starbase.dec=StarTable.dec
starbase.pmra=StarTable.pmra
starbase.pmdec=StarTable.pmdec
;
; Get FLN
StarTable.starid=bat_starids
rename_starids,'bat-fln'
starbase.fln=StarTable.fln
;
; Get star names from Bright Star Catalog
StarTable.starid=bat_starids
rename_starids,'bat-bsc'
read_catalogs
starbase.bsc=StarTable.bsc
;
; Replace StarTable with starbase
StarTable=starbase
;
; Do the math
amv_stars
d_stars
mass_stars
m_binaries
i_binaries
a_binaries
;
index=where(StarTable.a ne 0,count)
print,'Number of non-zero semi-major axis estimates :',count
;
end
