pro compile_speckle,date,rho,theta
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; With orbital elements stored in the startable, compute separations for given
; date and select all those double stars with separations less than 200 mas.
;
common StarBase,StarTable,Notes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
rad=180/pi_circle
;
; get_wds
;
if n_elements(StarTable) eq 0 then begin
	print,'***Error(COMPILE_SPECKLE): no StarTable!'
	return
endif
if n_elements(date) eq 0 then begin
	print,'***Error(COMPILE_SPECKLE): no date specified!'
	return
endif
n=n_elements(StarTable)
if n eq 0 then return
o_parms=dblarr(8,n)
rho=dblarr(n)
theta=rho
;
o_parms[0,*]=StarTable.a
o_parms[1,*]=StarTable.e
o_parms[2,*]=StarTable.i/rad
o_parms[2,*]=StarTable.i/rad
o_parms[3,*]=StarTable.o/rad
o_parms[5,*]=StarTable.n/rad
o_parms[6,*]=StarTable.p
o_parms[7,*]=StarTable.t
o_parms[7,*]=StarTable.t
;
parsedate,date,y,m,d
jd=julian(y,m,d)
;
for i=0,n-1 do begin
	xy=true2app(jd,o_parms[*,i],r,t,StarTable[i].ra,StarTable[i].dec)
	rho[i]=r
	theta[i]=t
endfor
;
index=where(rho lt 0.150,count)
if count gt 0 then begin
	StarTable=StarTable[index]
	rho=rho[index]
	theta=theta[index]
endif else print,'No stars found!'
;
end
