pro compile_technical,rho,rho_min=rho_min,rho_max=rho_max, $
	ra_min=ra_min,ra_max=ra_max, $
	v_max=v_max,k_max=k_max, $
	flp_min=flp_min,f12_min=f12_min
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compile list of binaries for technical tests at VLTI. Rho["]
; compile_technical,rho,rho_min=0.02,rho_max=0.1,flp_min=1,f12_min=30
; rho_min=0.05,rho_max=0.2,ra_min=10,ra_max=20,flp_min=20,f12_min=80
;
common StarBase,StarTable,Notes
;
; Compile list of southern binaries with orbits
compile_wdssouth,rho
;
; If RA range was not provided, initialize for current date
if n_elements(ra_min) eq 0 or n_elements(ra_max) eq 0 then begin
	words=nameparse(systime())
	jd0=julian(fix(words[4]),1,1)
	doy=systime(/julian)-jd0
;	Original version
	ra_min=12.+(doy-90)/7.5-2.0
	ra_max=ra_min+11
;	Rising to setting
	ra_min=(doy/365.)*24-4.0
	ra_max=ra_min+21
;	Culminating
	ra_min=(doy/365.)*24
	ra_max=(ra_min+12) mod 24
	print,'Selecting RA range: ',ra_min,ra_max
endif
if ra_max lt ra_min then begin
	ra_max=ra_max+24
	index=where(startable.ra lt ra_min,count)
	if count gt 0 then startable[index].ra=startable[index].ra+24
endif
index=where(startable.ra gt ra_min and startable.ra lt ra_max)
startable=startable[index]
startable.ra=startable.ra mod 24
rho=rho[index]
t1=startable
r1=rho
;
; Compile list of all binaries
compile_wdssouth,rho,/bible
compile_wdssouth,rho,/simbad
t2=startable
r2=rho
index=where(t2.ra gt ra_min and t2.ra lt ra_max)
t2=t2[index]
t2.ra=t2.ra mod 24
r2=r2[index]
; Merge the two lists, keep orbital binaries
index=whereequal(t2.starid,t1.starid)
t2[index].starid=''
index=where(strlen(t2.starid) ne 0)
startable=[t2[index],t1]
rho=[r2[index],r1]
;
; Select all binaries with separation greater than limit
if n_elements(rho_min) eq 0 then rho_min=min(rho)
index=where(rho ge rho_min)
startable=startable[index] & rho=rho[index]
;
; Select all binaries with separation less than limit
if n_elements(rho_max) eq 0 then begin
	rho_max=0.2
	print,'Limiting maximum separation ["] to:',rho_max
endif
index=where(rho le rho_max)
startable=startable[index] & rho=rho[index]
;
; Select on visual magnitude
if n_elements(v_max) eq 0 then begin
	v_max=12
	print,'Limiting faintest visual mag. to:',v_max
endif
index=where(startable.mv le v_max)
startable=startable[index] & rho=rho[index]
;
; Get more HDN IDs from crossindex file
st=startable
rename_starids,'wds-hdn'
st.hdn=startable.hdn
startable=st
;
; For stars with HD number, look for MID-IR fluxes in MDFC
get_mdfc
;
; Select on K magnitude
if n_elements(k_max) eq 0 then begin
	k_max=9
	print,'Limiting faintest K magnitude to:',k_max
endif
; Get JHK magnitudes from hip_2mass extension and select for k < k_max
get_2mass,k_max=k_max
;
; get_wise,k_max=k_max
; index=where(startable.mk ne 100)
; startable=startable(index)
; rho=rho(index)
;
; Select only stars with (B-V) value for Teff estimation
index=where(startable.bv ne 100)
startable=startable[index] & rho=rho[index]
;
; For the estimation of the 1pc fluxes, we need Teff and lum. class
; If the luminosity class is not known, we adopt class=5 (dwarfs)
index=where(startable.class eq 0,count)
if count gt 0 then startable[index].class=5
;
; Estimate L and N-band fluxes for those stars not found in MDFC
i=where(startable.flp eq 0 or startable.f12 eq 0)
; Restore calibration tables: rlg,rld,rng,rnd (see mdfc_cal in mymatissegui.pro)
restore,!oyster_dir+'starbase/MDFC/mdfc_ln_coeffs.xdr'
;
j=where(startable[i].class ge 4.5 and startable[i].class le 5)
startable[i[j]].flp=poly(teff_bv(startable[i[j]].bv),rld)*startable[i[j]].px^2
startable[i[j]].f12=poly(teff_bv(startable[i[j]].bv),rnd)*startable[i[j]].px^2
;
j=where(startable[i].class ge 2.5 and startable[i].class le 3.5)
startable[i[j]].flp=poly(teff_bv(startable[i[j]].bv),rlg)*startable[i[j]].px^2
startable[i[j]].f12=poly(teff_bv(startable[i[j]].bv),rng)*startable[i[j]].px^2
;
index=where(startable.flp gt 0 and startable.f12 gt 0)
startable=startable[index] & rho=rho[index]
;
; Select on L and N fluxes (Jy)
if n_elements(flp_min) eq 0 then flp_min=min(startable.flp)
if n_elements(f12_min) eq 0 then f12_min=min(startable.f12)
index=where(startable.flp gt flp_min and startable.f12 gt f12_min,count)
if count eq 0 then begin
	print,'No stars found within the specified limits!'
	return
endif
if count ge 1 then begin
	startable=startable[index] & rho=rho[index]
endif
;
; Find HD or HIC numbers
IF 0 THEN BEGIN
rename_starids,'wds-hdn'
;
index=where(startable.hdn eq 0,n)
for i=0,n-1 do begin
  star=cri_simbad('OBJ'+esoid(startable[index[i]].ra,startable[index[i]].dec),t)
  if strpos(star,'HD') ge 0 then begin
	words=nameparse(star)
	if n_elements(words) eq 2 then $
	startable[index[i]].hdn=long(words[1])
  endif
  if strpos(star,'HIC') ge 0 then begin
	words=nameparse(star)
	if n_elements(words) eq 2 then $
	startable[index[i]].hic=long(words[1])
  endif
endfor
ENDIF
;
; Estimate primary diameters from V and (V-K)
t=startable
index=where(startable.dmv eq 100.0)
startable[index].dmv=2
m1m2v=dmag(startable.mv,startable.dmv)
m1m2k=dmag(startable.mk,startable.dmv)
startable.mv=reform(m1m2v[0,*])
startable.mk=reform(m1m2k[0,*])
diameter_vk,/force
diameter=startable.diameter
startable=t
startable.diameter=diameter
index=where(startable.diameter lt 15)
startable=startable[index] & rho=rho[index]
;
; Store rho in semimajor axis and write list of binaries
startable.a=rho
;
; Return here, code following is no longer used
return
;
; Select maximum magnitude difference
index=where(startable.dmv lt 3 and startable.dmv ne 100.0)
startable=startable[index]
rho=rho[index]
;
; Get Greek letter names
startable.starid='HDN'+string(startable.hdn,format='(i6.6)')
t=startable
rename_starids,'hdn-bsc'
read_catalogs
rename_bsc
t.name=startable.name
t.spectrum=startable.spectrum
startable=t
;
; Get astrometry from Hipparcos
t=startable
rename_starids,'hdn-hip'
read_catalogs
t.ra=startable.ra
t.dec=startable.dec
t.pmra=startable.pmra
t.pmdec=startable.pmdec
startable=t
;
end
