pro compile_wdssouth,rho,bible=bible,simbad=simbad
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compile list of binaries with orbits from WDS in the southern hemisphere.
; If keyword "bible" is set, use the bible of all binary detections.
; If keyword "simbad" is set, use the WDS entries in SimBad (yields mags).
; For known orbits, compute separation rho ["] at the current date.
;
common StarBase,StarTable,Notes
common FitAstrometry,ellipse_options,orbit_options,e_parms,o_parms
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
if n_elements(bible) eq 0 then bible=0
if n_elements(simbad) eq 0 then simbad=0
if simbad and bible then begin
	print,'Please choose only one option: bible or simbad!'
	return
endif
;
orbit_options=alloc_orbit_options()
orbit_options.component='A-B'
;
IF bible THEN BEGIN
	get_wbs
	rho=startable.a
ENDIF ELSE IF simbad THEN BEGIN
	restore,!catalogs_dir+'/simbad/wdssim.xdr'
ENDIF ELSE BEGIN
	get_wds
	nb=n_elements(startable)
;
	b_parms=dblarr(7,nb)
	b_parms[0,*]=startable.a
	b_parms[1,*]=startable.e
	b_parms[2,*]=startable.i*!pi/180
	b_parms[3,*]=((startable.o+180) mod 360)*!pi/180
	b_parms[4,*]=startable.n*!pi/180
	b_parms[5,*]=startable.p
	b_parms[6,*]=startable.t-2440000.d0
;
	rho=fltarr(nb)
;
	parseidldate,systime(),y,m,d
	jd=julian(y,m,d)
;
	!quiet=1
	for ib=0,nb-1 do begin
		o_parms=b_parms[*,ib]
		setmodel
		rhotheta=binarypos(jd)
		rho[ib]=rhotheta[0]
	endfor
	!quiet=0
ENDELSE
;
; Select southern targets for VLTI
index=where(startable.dec lt 20,count)
if count ge 1 then begin
	startable=startable[index]
	rho=rho[index]
endif
;
; Process spectrum information
spec_parse,startable.spectrum,type,class,type2,class2
startable.type=type
startable.class=class
startable.type2=type2
startable.class2=class2
;
end
