pro compileobslist
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Finalize information on a list of stars for observations. Also reorder
; by neighboring stars.
;
common StarBase,startable,notes
;
if n_elements(startable) eq 0 then begin
	print,'***Error(COMPILEOBSLIST): startable undefined!'
	return
endif
;
; Default information is from the BSC
rename_starids,'bat-bsc'
rename_starids,'hdn-bsc'
rename_starids,'fkv-bsc'
read_catalogs
;
; Get the diameters
get_diameter
;
; Get the names
rename_bsc
;
; Get the star positions from the FK5
table=startable
rename_starids,'bsc-fkv'
read_catalogs
table.starid=startable.starid
table.fkv=startable.fkv
table.ra=startable.ra
table.dec=startable.dec
startable=table
;
; Sort by RA to insure first stars are in the west
if n_elements(startable) eq 1 then si=0 else si=sort(startable.ra)
startable=startable[si]
;
; Go through list to determine the grouping
RAD=180/!pi
ra=startable.ra*15/RAD
dec=startable.dec/RAD
n=n_elements(startable)
si=intarr(n)
si[0]=1
j=0
for i=1,n-1 do begin
	index=where(si eq 0)
	dist=sqrt(((ra[index]-ra[j])*cos(dec[index]))^2+(dec[index]-dec[j])^2)
	j=index[where(dist eq min(dist))] & j=j[0]
	si[j]=i+1
endfor
startable=startable[sort(si)]
;
end
