function componentfluxes,epoch,lamda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Convenience function to compute the fluxes of the individual components of
; a model. Returns a string array
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
; Initialize parameters for convenience use
if n_elements(epoch) eq 0 then epoch=systime(/julian)-2440000.d0
if n_elements(lamda) eq 0 then lamda=mean(gen_model.wavelengths)*1e-6
;
components=star_model.component
fluxes=strarr(n_elements(components))
;
for i=0,n_elements(components)-1 do begin
	fluxes[i]=string(componentflux(components[i],epoch,lamda))
	components[i]=blanks(strlen(fluxes[i])-1)+components[i]
endfor
;
return,[[components],[fluxes]]
;
end
