function componentmass,comp_1,comp_2,num_body,index_comp
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute the component masses (=sum of stellar masses)
; Components specified as returned by componentparse, e.g. 'AB', 'C'
;
common Model,gen_model,star_model,binary_model,gen_error,star_error,binary_error
;
components=[comp_1,comp_2]
num_body=[strlen(comp_1),strlen(comp_2)]
index_comp=intarr(max(num_body),2)
mass_sum=dblarr(2)
for k=0,1 do begin
	for j=0,num_body[k]-1 do begin
		index=where(strmid(components[k],j,1) eq star_model.component)
		mass_sum[k]=mass_sum[k]+star_model[index[0]].mass
		index_comp[j,k]=index[0]
	endfor
endfor
;
return,mass_sum
;
end
