pro constrictor,confile,rawpath=rawpath,items=items,stars=stars, $
	classic=classic,numcoh=numcoh
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; New 6-way compatible version. This procedure, with the same name as the
; standard NPOI raw data averager, is used to replace certain variables with
; better estimates. New functionality can also be added here.
;
; Coherent integration of 6-way data using baseline boot strapping.
; Currently uses only baselines to the reference station.
;
; Available items for pointdata:
; FDLPOS, FDLPOSERR
; NATCOUNTS
; FRINGEJITTER
; COHERENT
;
; Available items for scandata (and corresponding plot variable):
; NATJITTER		NATJITTER2
; SCINTILLATION		SCINTILLATION
; T0			T0
; DELAYRMS		DELAYRMS
; DELAYJITTER		DELAYJITTER2
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(rawpath) eq 0 then rp='' else rp=rawpath+'/'
if n_elements(items) eq 0 then begin
	print,'Warning(CONSTRICTOR): items undefined, setting to "SEEING"!'
	items=['NATJITTER','SCINTILLATION','T0', $
	       'DELAYRMS','DELAYJITTER','FRINGEJITTER']
endif
if n_elements(classic) eq 0 then classic=1
if n_elements(numcoh) eq 0 then numcoh=100L else numcoh=long(numcoh)
;
; Open existing output file to read some info
hds_close	; In case a file is open
hds_open,confile
get_scantable
get_sysconfig
fixearlydays
np=scantable.numpoint
scan_ids=scantable.scanid
numscan=n_elements(scan_ids)
numav=scantable.numcoh*scantable.numincoh
numincoh=numav/numcoh
hds_close
;
; Do all stars if none are specified
if n_elements(stars) eq 0 then list_stars,stars
;
stub=rp+checkdate()+'.raw.'
;
; Loop over all scans
FOR i=0,numscan-1 DO BEGIN
;
rawfile=stub+string(scan_ids[i],format='(i3.3)')+'.01'
print,'Now processing ',rawfile,'...'
hds_open,rawfile,'READ',status & if status ne 0 then return
get_rawdata
hds_close
;
dp=double(fdlstamp())/86400000*2*!pi
;
if n_elements(add(timestamp,numcoh*numincoh[i])) ne np[i] then begin
	print,'***ERROR(CONSTRICTOR): bad # of samples scan'+string(i+1)+'!'
	return
endif
;
index=where(stars eq scantable[0].starid,count)
;
IF count eq 1 THEN BEGIN
;
; INPUTBEAM section +++
;
; Point data section
;
; FDLPos
if strpos(strupcase(strjoin(items)),'FDLPOS') ne -1 then begin
for j=0,genconfig.numsid-1 do begin
;
fdlposerr=fltarr(np[i])
fdlpos=dblarr(np[i])
;
if j ne genconfig.refstation-1 then begin
	f=fdldelay(genconfig.stationid[j]+'-' $
	  +genconfig.stationid[genconfig.refstation-1],coeffs=coeffs)
	df=f-shift(f,1)
	for l=0,np[i]-1 do begin
		fdlpos[l]=-(median(f[l*numincoh[i]:(l+1)*numincoh[i]-1]) $
			 +perinom(avg(dp[l*numincoh[i]:(l+1)*numincoh[i]-1]),coeffs))
		fdlposerr[l]=abs(medianve(df[l*numincoh[i]:(l+1)*numincoh[i]-1]) $
				*numincoh[i])
		if fdlposerr[l] eq 0 then fdlposerr[l]=1e-6
	endfor
;
	hds_open,confile,'UPDATE',status & if status ne 0 then return
	dat_find,'SCANDATA'
	dat_find,'POINTDATA'
	dat_cell,1,i+1
	dat_find,'INPUTBEAM'
	dat_cell,1,j+1
;
	ndim=1
	dims=np[i]
	name='FDLPOSERR'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,fdlposerr
	name='FDLPOS'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_double'
	dat_new,name,type,ndim,dims
	cmp_putnd,name,ndim,dims,fdlpos
	hds_close
endif
;
endfor
endif
;
; NATCounts
if strpos(strupcase(strjoin(items)),'NATCOUNTS') ne -1 then begin
for j=0,genconfig.numsid-1 do begin
;
	natcounts=add(total(reform(quadcounts[j,*,*]),1),numincoh[i])/numincoh[i]
;
	hds_open,confile,'UPDATE',status & if status ne 0 then return
	dat_find,'SCANDATA'
	dat_find,'POINTDATA'
	dat_cell,1,i+1
	dat_find,'INPUTBEAM'
	dat_cell,1,j+1
;
	ndim=1
	dims=np[i]
	name='NATCOUNTS'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,natcounts
	hds_close
;
endfor
endif
;
; Scan averaged data section
;
; Seeing index based on angle jitter
if strpos(strupcase(strjoin(items)),'NATJITTER') ne -1 then begin
;
if n_elements(natjitter) eq 0 then $
natjitter=fltarr(genconfig.numsid,2,numscan)
;
binsize=0.04
numbin=nint(2.0/binsize)+1
x=(findgen(numbin)-float(numbin-2)/2)*binsize
;
for j=0,genconfig.numsid-1 do begin
;
	if median(quadcounts[j,*,*]) gt 10 then begin
	xy=natoffset(quadcounts[j,*,*])
	y=lonarr(numbin,numbin)
	for k=0,numbin-1 do begin
		index=where(xy[*,1] ge x[k]-binsize/2 $
			and xy[*,1] lt x[k]+binsize/2,count)
		if count gt 0 then $
		y[*,k]=histogram(xy[index,0],min=-1,binsize=binsize,max=1)
	endfor
;
;	Measure width in X and Y (more stable than Gaussian fit)
	yx=total(y,2)
	yy=total(y,1)
	xindex=where(yx gt max(yx)/2)
	yindex=where(yy gt max(yy)/2)
	natjitter[j,0,i]=(max(xindex)-min(xindex))*binsize
	natjitter[j,1,i]=(max(yindex)-min(yindex))*binsize
;	Fit Gaussian profile to 2D histogram
;	aparm=fltarr(7)
;	aparm=[0.0,max(y),7.0,7.0,24.,24.,0.0]
;	r=gauss2dfit(y,aparm)
;	natjitter(j,0,i)=aparm(2)*binsize
;	natjitter(j,1,i)=aparm(3)*binsize
	endif
;
endfor
endif
;
; OUTPUTBEAM section +++
;
; Point data section
;
; FringeJitter (motion of fringe after tracking)
if strpos(strupcase(strjoin(items)),'FRINGEJITTER') ne -1 then begin
if scantable[0].code eq 1 then begin
;
for j=0,genconfig.numoutbeam-1 do begin
	hds_open,rawfile,'READ',status & if status ne 0 then return
	get_bincounts,j+1
;
	fringejitter=fltarr(genconfig.numbaseline[j],np[i])
;
	for k=0,genconfig.numbaseline[j]-1 do begin
		if onsource(genconfig.baselineid[k,j]) then begin
		g=fringedelays(k+1)
		for l=0,np[i]-1 do begin
			v=medianve(g[l*numincoh[i]:(l+1)*numincoh[i]-1],ve)
			fringejitter[k,l]=ve
		endfor
		endif
	endfor
	hds_close
;
	hds_open,confile,'UPDATE',status & if status ne 0 then return
	dat_find,'SCANDATA'
	dat_find,'POINTDATA'
	dat_cell,1,i+1
	dat_find,'OUTPUTBEAM'
	dat_cell,1,j+1
;
	ndim=2
	dims=[genconfig.numbaseline[j],np[i]]
	name='FRINGEJITTER'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,fringejitter
	hds_close
endfor
;
endif
endif
;
; Coherent integration of visibilities
if strpos(strupcase(strjoin(items)),'COHERENT') ne -1 then begin
;
; These arrays store the raw data
d=fltarr(genconfig.numoutbeam,max(genconfig.numbaseline),n_elements(timestamp))
g=intarr(genconfig.numoutbeam,max(genconfig.numbaseline),n_elements(timestamp))
v=complexarr(genconfig.numoutbeam,max(genconfig.numspecchan), $
				  max(genconfig.numbaseline),n_elements(timestamp))
;
; These arrays hold coherent data
vis=complexarr(genconfig.numoutbeam,max(genconfig.numspecchan), $
	max(genconfig.numbaseline),n_elements(timestamp)/numcoh)
var=fltarr(genconfig.numoutbeam,max(genconfig.numspecchan), $
	n_elements(timestamp)/numcoh)
nph=fltarr(genconfig.numoutbeam,max(genconfig.numspecchan), $
	n_elements(timestamp)/numcoh)
;
; These arrays hold the point data
vsq=fltarr(genconfig.numoutbeam,max(genconfig.numspecchan),max(genconfig.numbase
vse=vsq
t3v=complexarr(genconfig.numtriple,max(genconfig.numspecchan),np[i])
t3e=t3v
;
; Design matrix and right hand side
nrow=fix(total(genconfig.numbaseline))
dm=fltarr(nrow+1,genconfig.numsid)
rh=fltarr(nrow+1,n_elements(timestamp))
row=0
;
; Compute fringe delays and design matrix
for j=0,genconfig.numoutbeam-1 do begin
;
ch=channelindex[genconfig.spectrometerid[j]]-1
l=genconfig.wavelength[ch,j]
;
hds_open,rawfile,'READ',status
get_bincounts,j+1
hds_close
;
for k=0,genconfig.numbaseline[j]-1 do begin
i1=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],0,3))
i2=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],4,3))
i1=i1[0]
i2=i2[0]
if scantable[0].station(i1) ne 0 and scantable[0].station(i2) ne 0 then begin
	v[j,*,k,*]=fringevis(bincounts,genconfig.fringemod[k,j])
	if scantable.code eq 1 then begin
	if i1+1 eq genconfig.refstation $
	or i2+1 eq genconfig.refstation then begin
	if classic then begin
		d[j,k,*]=fringedelay(v[j,ch,k,*],l, $
				fdldelay(genconfig.baselineid[k,j]), $
			        fdlstamp()/1000.d0)
	endif else begin
		d[j,k,*]=fringedelay(v[j,ch,k,*],l, $
				fdldelay(genconfig.baselineid[k,j]), $
				fdlstamp()/1000.d0,gindex)
		g[j,k,*]=gindex
	endelse
	dm[row,i1]=+1
	dm[row,i2]=-1
	rh[row,*]=d[j,k,*]
	endif
	endif
endif
row=row+1
endfor
endfor
;
; Compute delay solutions
if scantable.code eq 1 then begin
dm[nrow,genconfig.refstation-1]=1
tm=transpose(dm)
nm=tm#dm
y=tm#rh
; s=invert(nm)#y
;
svd,nm,w_eigen,u_matrix,v_matrix
small=where(w_eigen lt max(w_eigen)*1e-6,count)
for j=0,count-1 do begin
	w_eigen[small[j]]=0
endfor
s=y
for n=0,n_elements(TimeStamp)-1 do begin
svbksb,u_matrix,w_eigen,v_matrix,y[*,n],sol
s[*,n]=sol
endfor
;
; for k=0l,n_elements(timestamp)-1 do begin
; 	y=r(*,k)
; 	tm=transpose(dm)
; 	nm=tm#dm
; 	r=tm#y
; 	s=invert(n)#r
; endfor
endif else s=fltarr(genconfig.numsid,n_elements(timestamp))
;
; Do the coherent integration
for j=0,genconfig.numoutbeam-1 do begin
;
hds_open,rawfile,'READ',status
get_bincounts,j+1
hds_close
;
; nph(j,*,*)=add(fringenphot(bincounts),numcoh,1)
nph[j,*,*]=fringenphot(add(float(bincounts),numcoh,2))
var[j,*,*]=nph[j,*,*]	; Poisson noise variance
;
for k=0,genconfig.numbaseline[j]-1 do begin
i1=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],0,3))
i2=where(genconfig.stationid eq strmid(genconfig.baselineid[k,j],4,3))
i1=i1[0]
i2=i2[0]
if scantable[0].station(i1) ne 0 and scantable[0].station(i2) ne 0 then begin
	d[j,k,*]=s[i1,*]-s[i2,*]
	r=reform(visrotate(v[j,*,k,*],genconfig.wavelength[*,j],d[j,k,*]))
	if classic then begin
		vis[j,*,k,*]=add(r,numcoh,1)
	endif else begin
		for ip=0,np[i]-1 do begin
			rg=r[*,ip*numcoh:(ip+1)*numcoh-1]
			gi=g[k,ip*numcoh:(ip+1)*numcoh-1]
			dg=d[k,ip*numcoh:(ip+1)*numcoh-1]
			index=where(gi gt 0,count)
			if count ge 2 then $
				vis[j,*,k,ip]=summe(rg[*,index],1)/count
		endfor
	endelse
endif
endfor
endfor
;
; Do the incoherent integration of the squared visibilities
for j=0,genconfig.numoutbeam-1 do begin
for k=0,genconfig.numbaseline[j]-1 do begin
	vsq[j,*,k,*]=add(abs(vis[j,*,k,*])^2-var[j,*,*],numincoh[i],3,sd=sd) $
		    /(numincoh[i]*numcoh^2)
	vse[j,*,k,*]=(sd/numcoh^2)/sqrt(numincoh[i])
endfor
endfor
;
; Do the coherent integration of the triple products
for j=0,genconfig.numtriple-1 do begin
;
fBaseMatrix=intarr(GenConfig.NumSid,3)
fBaseFactor=fltarr(3)+1
vis3=complexarr(3,genconfig.triplenumchan[j],n_elements(timestamp)/numcoh)
bias=0.
for l=0,2 do begin
        ob=GenConfig.TripleBeam[l,j]
        bl=GenConfig.TripleBase[l,j]
	ch=GenConfig.TripleChan[0:genconfig.triplenumchan[j]-1,l,j]
        j1=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[bl,ob],0,3))
        j2=where(GenConfig.StationId eq strmid(GenConfig.BaselineId[bl,ob],4,3))
	j1=j1[0]
	j2=j2[0]
        fBaseMatrix[j1,l]=+1
        fBaseMatrix[j2,l]=-1
        if l gt 0 then fBaseFactor[l]=(-total(fBaseMatrix[*,0]*fBaseMatrix[*,l])
	vis3[l,*,*]=vis[ob,ch,bl,*]
	if fBaseFactor[l] lt 1 then vis3[l,*,*]=conj(vis3[l,*,*])
	bias=bias+abs(vis[ob,ch,bl,*])^2
endfor
bias=bias-2*nph[ob,ch,*]
tvis=vis3[0,*,*]*vis3[1,*,*]*vis3[2,*,*]
if genconfig.triplebeam[0,j] eq genconfig.triplebeam[1,j] and $
   genconfig.triplebeam[1,j] eq genconfig.triplebeam[2,j] then tvis=tvis-bias
t3v[j,*,*]=add(tvis,numincoh[i],2,sd=sd)/(numincoh[i]*numcoh^3)
; amperr=float(sd)/numcoh^3
; phserr=imaginary(sd)
; t3e(j,*,*)=complex(amperr,phserr)
t3e[j,*,*]=(sd/numcoh^3)/sqrt(numincoh[i])
;
endfor
;
; Write results to file
hds_open,confile,'UPDATE',status & if status ne 0 then return
dat_find,'SCANDATA'
dat_find,'POINTDATA'
dat_cell,1,i+1
;
dat_find,'OUTPUTBEAM'
for j=0,genconfig.numoutbeam-1 do begin
	dat_cell,1,j+1
	name='VISSQ'
	type='_real'
	ndim=3
	dims=[genconfig.numspecchan[j],genconfig.numbaseline[j],np[i]]
	data=reform(vsq[j,*,*,*])
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
	name='VISSQERR'
	data=reform(vse[j,*,*,*])
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
	dat_annul
endfor
dat_annul
;
dat_find,'TRIPLE'
for j=0,genconfig.numtriple-1 do begin
	dat_cell,1,j+1
	name='COMPLTRIPLE'
	ndim=3
	type='_real'
	dims=[2,genconfig.triplenumchan[j],np[i]]
	data=fltarr(dims[0],dims[1],dims[2],/nozero)
	data[0,*,*]=float(t3v[j,*,*])
	data[1,*,*]=imaginary(t3v[j,*,*])
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
	name='COMPLTRIPLEERR'
	data[0,*,*]=float(t3e[j,*,*])
	data[1,*,*]=imaginary(t3e[j,*,*])
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
	dat_annul
endfor
;
hds_close
;
endif
;
; Scan averaged data section
;
; Scintillation index
if strpos(strupcase(strjoin(items)),'SCINTILLATION') ne -1 then begin
;
if n_elements(scintillation) eq 0 then $
scintillation=fltarr(genconfig.numoutbeam,max(genconfig.numspecchan),numscan)
;
for k=0,genconfig.numoutbeam-1 do begin
	hds_open,rawfile,'READ',status & if status ne 0 then return
	get_bincounts,k+1
	hds_close
	for j=0,genconfig.numspecchan[k]-1 do begin
		tc=summe(float(reform(bincounts[*,j,*])),0)
		binsize=1
		fr=histogram(tc,min=0,binsize=binsize)
		x=findgen(n_elements(fr))*binsize+binsize/2
		m=median(long(tc))
		y=eqp(m,long(x))*n_elements(tc)*binsize
		scintillation[k,j,i]=max(y)/max(fr)
	endfor
endfor
endif
;
; Coherence time t0
if strpos(strupcase(strjoin(items)),'T0') ne -1 then begin
if scantable[0].code eq 1 then begin
;
n=[1,2,3,4,6,8,10,15,20,25]
n=[1,2,4,8,15,25]
nn=n_elements(n)
dt=fltarr(nn)
;
if n_elements(t0) eq 0 then $
t0=fltarr(genconfig.numoutbeam,max(genconfig.numspecchan),max(genconfig.numbasel
;
for k=0,genconfig.numoutbeam-1 do begin
	hds_open,rawfile,'READ',status & if status ne 0 then return
	get_bincounts,k+1
	hds_close
;
;	t0=fltarr(genconfig.numspecchan(k),genconfig.numbaseline(k))
	v2=fltarr(nn,genconfig.numspecchan[k],genconfig.numbaseline[k])
;
	for m=0,nn-1 do begin
	dt[m]=n[m]*genconfig.instrcohint
;	c=add(fix(bincounts),n(m),2)
	c=addbincounts(fix(bincounts),n[m])
	p=fringenphot(c)
	z=fringemphot(c)
	num=n_elements(p[0,*])
	for l=0,genconfig.numbaseline[k]-1 do begin
	if onsource(genconfig.baselineid[l,k]) then begin
	norm_factor=4.0/sinc(float(genconfig.fringemod[l,k])/genconfig.numbin)^2
	v=fringevis(c,genconfig.fringemod[l,k])
	v2[m,*,l]=num*norm_factor*summe(abs(v)^2-z^2,1)/summe(p,1)^2
	endif
	endfor
	endfor
	for j=0,genconfig.numspecchan[k]-1 do begin
	for l=0,genconfig.numbaseline[k]*0+1-1 do begin
	if onsource(genconfig.baselineid[l,k]) then begin
	if v2[0,j,l] gt 0 and v2[0,j,l] lt 1 $
			  and v2[nn-1,j,l]/v2[0,j,l] lt 0.5 then begin
		a=[v2[0,j,l],2.0]
		v2fit=curvefit(dt,v2[*,j,l],v2[*,j,l]*0+1,a, $
			function_name='funct_coherence',/noderivat)
		t0[k,j,l,i]=a[1]
	endif
	endif
	endfor
	endfor
endfor
;
endif
endif
;
; Tracking delay RMS over whole scan
if strpos(strupcase(strjoin(items)),'DELAYRMS') ne -1 then begin
if scantable[0].code eq 1 then begin
;
if n_elements(delayrms) eq 0 then $
delayrms=fltarr(genconfig.numoutbeam,max(genconfig.numbaseline),numscan)
;
for k=0,genconfig.numoutbeam-1 do begin
for l=0,genconfig.numbaseline[k]-1 do begin
	delayrms[k,l,i]=stddev(fdldelay(l+1,k+1))*1e6
endfor
endfor
;
endif
endif
;
; Tracking delay jitter (RMS of FDL-smoothed(FDL))
if strpos(strupcase(strjoin(items)),'DELAYJITTER') ne -1 then begin
if scantable[0].code eq 1 then begin
;
if n_elements(delayjitter) eq 0 then $
delayjitter=fltarr(genconfig.numoutbeam,max(genconfig.numbaseline),numscan)
;
for k=0,genconfig.numoutbeam-1 do begin
for l=0,genconfig.numbaseline[k]-1 do begin
	d=fdldelay(l+1,k+1)
	delayjitter[k,l,i]=stddev(d-gsmooth(float(fdlstamp())/1000,d,1,/c8))*1e6
endfor
endfor
;
endif
endif
;
ENDIF
ENDFOR
;
; Update scantable
hds_open,confile,'UPDATE',status & if status ne 0 then return
dat_find,'SCANDATA'
;
if strpos(strupcase(strjoin(items)),'COHERENT') ne -1 then begin
	name='NUMCOH'
	dat_erase,name
	type='_integer'
	ndim=1
	dims=lonarr(7)
	dims[0]=numscan
	dat_new,name,type,ndim,dims
	cmp_put1i,name,lonarr(numscan)+numcoh
;
	name='NUMINCOH'
	dat_erase,name
	type='_integer'
	ndim=1
	dims[0]=numscan
	dat_new,name,type,ndim,dims
	cmp_put1i,name,numincoh
endif
;
if n_elements(natjitter) ne 0 then begin
	dat_find,'INPUTBEAM',status
	if status ne 0 then begin
		ndim=1L
		dims=lonarr(7)
		dims[0]=genconfig.numsid
		type='EXTCOLUMN'
		dat_new,'INPUTBEAM',type,ndim,dims
		dat_find,'INPUTBEAM'
	endif
	ndim=2
	dims=[2,numscan]
	data=fltarr(dims[0],dims[1],/nozero)
;
	for k=0,genconfig.numsid-1 do begin
	dat_cell,1,k+1
;
	name='NATJITTER'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	data[*]=natjitter[k,*,*]
	cmp_putnr,name,ndim,dims,data
	dat_annul
	endfor
	dat_annul
endif
;
if n_elements(scintillation) ne 0 then begin
	dat_find,'OUTPUTBEAM',status
	if status ne 0 then begin
		ndim=1L
		dims=lonarr(7)
		dims[0]=genconfig.numoutbeam
		type='EXTCOLUMN'
		dat_new,'OUTPUTBEAM',type,ndim,dims
		dat_find,'OUTPUTBEAM'
	endif
	ndim=2
	dims=[max(genconfig.numspecchan),numscan]
	data=fltarr(dims[0],dims[1],/nozero)
;
	for k=0,genconfig.numoutbeam-1 do begin
	dat_cell,1,k+1
;
	name='SCINTILLATION'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	data[*]=scintillation[k,*,*]
	cmp_putnr,name,ndim,dims,data
	dat_annul
	endfor
	dat_annul
endif
;
if n_elements(t0) ne 0 then begin
	dat_find,'OUTPUTBEAM',status
	if status ne 0 then begin
		ndim=1L
		dims=lonarr(7)
		dims[0]=genconfig.numoutbeam
		type='EXTCOLUMN'
		dat_new,'OUTPUTBEAM',type,ndim,dims
		dat_find,'OUTPUTBEAM'
	endif
	ndim=3
	dims=[max(genconfig.numspecchan),max(genconfig.numbaseline),numscan]
	data=fltarr(dims[0],dims[1],dims[2],/nozero)
;
	for k=0,genconfig.numoutbeam-1 do begin
	dat_cell,1,k+1
;
	name='T0'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	data[*]=t0[k,*,*,*]
	cmp_putnr,name,ndim,dims,data
	dat_annul
	endfor
	dat_annul
endif
;
if n_elements(delayrms) ne 0 then begin
	dat_find,'OUTPUTBEAM',status
	if status ne 0 then begin
		ndim=1L
		dims=lonarr(7)
		dims[0]=genconfig.numoutbeam
		type='EXTCOLUMN'
		dat_new,'OUTPUTBEAM',type,ndim,dims
		dat_find,'OUTPUTBEAM'
	endif
	ndim=2
	dims=[max(genconfig.numbaseline),numscan]
	data=fltarr(dims[0],dims[1],/nozero)
;
	for k=0,genconfig.numoutbeam-1 do begin
	dat_cell,1,k+1
;
	name='DELAYRMS'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	data[*]=delayrms[k,*,*]
	cmp_putnr,name,ndim,dims,data
	dat_annul
	endfor
	dat_annul
endif
;
if n_elements(delayjitter) ne 0 then begin
	dat_find,'OUTPUTBEAM',status
	if status ne 0 then begin
		ndim=1L
		dims=lonarr(7)
		dims[0]=genconfig.numoutbeam
		type='EXTCOLUMN'
		dat_new,'OUTPUTBEAM',type,ndim,dims
		dat_find,'OUTPUTBEAM'
	endif
	ndim=2
	dims=[max(genconfig.numbaseline),numscan]
	data=fltarr(dims[0],dims[1],/nozero)
;
	for k=0,genconfig.numoutbeam-1 do begin
	dat_cell,1,k+1
;
	name='DELAYJITTER'
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	type='_real'
	dat_new,name,type,ndim,dims
	data[*]=delayjitter[k,*,*]
	cmp_putnr,name,ndim,dims,data
	dat_annul
	endfor
	dat_annul
endif
;
hds_close
;
end
