pro constrictor3,confile,stars=stars,numcoh=numcoh,code=code
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; This coherent integration works with 3-way CEW data only
; and is only kept here as a reference.
; This code was used for the coherent integration of the Gamma Sagittae data.
;
; No uncertainty estimates are computed.
;
common Tables,ScanTable,BGTable,StationTable
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(numcoh) eq 0 then numcoh=10L
if n_elements(code) eq 0 then code=[0,1]
;
hds_open,confile
get_scantable
get_sysconfig
fixearlydays
np=scantable.numpoint
scan_ids=scantable.scanid
numav=scantable[0].numcoh*scantable[0].numincoh
numincoh=numav/numcoh
sc_code=scantable.code
scantable.numcoh=numcoh
scantable.numincoh=numincoh
numcohs=scantable.numcoh
numincohs=scantable.numincoh
hds_close
;
if n_elements(stars) eq 0 then list_stars,stars
;
if n_elements(rawpath) eq 0 then rp='' else rp=rawpath+'/'
stub=rp+checkdate()+'.raw.'
;
channels=stringparse('1-10,13-20')
ch=channels-1
;
n=n_elements(scan_ids)
for i=0,n-1 do begin
	rawfile=stub+string(scan_ids[i],format='(i3.3)')+'.01'
	print,'Now processing ',rawfile,'...'
	hds_open,rawfile,'READ',status
	if status ne 0 then return
	get_rawdata
	if n_elements(add(timestamp,numcoh*numincoh)) ne np[i] then begin
		print,'***ERROR(CONSTRICTOR): bad # of samples!'
		return
	endif
;
	index=where(stars eq scantable[0].starid,count1)
	index=where(code eq sc_code[i],count2)
;
	IF count1 eq 1 and count2 eq 1 THEN BEGIN
;
	get_bincounts,3
	v3=fringevis(bincounts)
	if sc_code[i] eq 1 then begin
		d3=fringedelay(v3[ch,*],genconfig.wavelength[ch,2], $
			fdldelay(genconfig.baselineid[0,2]),fdlstamp()/1000.d0)
		v3=add(visrotate(v3,genconfig.wavelength[*,2],d3),numcoh,1)
		rf=float(rotateframe(bincounts,genconfig.wavelength[*,2],d3))
;		vsq3=add(abs(v3)^2-fringemphot(add(rf,numcoh,2))^2,numincoh,1) $
;		    /(numincoh*numcoh^2)
		vsq3=add(abs(v3)^2-fringenphot(add(float(bincounts),numcoh,2)),numincoh,1) $
		    /(numincoh*numcoh^2)
	endif else begin
		v3=add(v3,numcoh,1)
;		vsq3=add(abs(v3)^2-fringemphot(add(float(bincounts),numcoh,2))^2,numincoh,1)
;		    /(numincoh*numcoh^2)
		vsq3=add(abs(v3)^2-fringenphot(add(float(bincounts),numcoh,2)),numincoh,1) $
		    /(numincoh*numcoh^2)
	endelse
;
	get_bincounts,2
	v2=fringevis(bincounts)
	if sc_code[i] eq 1 then begin
		d2=fringedelay(v2[ch,*],genconfig.wavelength[ch,1], $
			fdldelay(genconfig.baselineid[0,1]),fdlstamp()/1000.d0)
		v2=add(visrotate(v2,genconfig.wavelength[*,1],d2),numcoh,1)
		rf=float(rotateframe(bincounts,genconfig.wavelength[*,1],d2))
;		vsq2=add(abs(v2)^2-fringemphot(add(rf,numcoh,2))^2,numincoh,1) $
;		    /(numincoh*numcoh^2)
		vsq2=add(abs(v2)^2-fringenphot(add(float(bincounts),numcoh,2)),numincoh,1) $
		    /(numincoh*numcoh^2)
	endif else begin
		v2=add(v2,numcoh,1)
;		vsq2=add(abs(v2)^2-fringemphot(add(float(bincounts),numcoh,2))^2,numincoh,1)
;		    /(numincoh*numcoh^2)
		vsq2=add(abs(v2)^2-fringenphot(add(float(bincounts),numcoh,2)),numincoh,1) $
		    /(numincoh*numcoh^2)
	endelse
;
	get_bincounts,1
	v1=fringevis(bincounts)
	if sc_code[i] eq 1 then begin
		d1=fringedelay(v1[ch,*],genconfig.wavelength[ch,0], $
			fdldelay(genconfig.baselineid[0,0]),fdlstamp()/1000.d0)
		v1=add(visrotate(v1,genconfig.wavelength[*,0],d2-d3),numcoh,1)
		rf=float(rotateframe(bincounts,genconfig.wavelength[*,0],d2-d3))
;		vsq1=add(abs(v1)^2-fringemphot(add(rf,numcoh,2))^2,numincoh,1) $
;		    /(numincoh*numcoh^2)
		vsq1=add(abs(v1)^2-fringenphot(add(float(bincounts),numcoh,2)),numincoh,1) $
		    /(numincoh*numcoh^2)
	endif else begin
		v1=add(v1,numcoh,1)
;		vsq1=add(abs(v1)^2-fringemphot(add(float(bincounts),numcoh,2))^2,numincoh,1)
;		    /(numincoh*numcoh^2)
		vsq1=add(abs(v1)^2-fringenphot(add(float(bincounts),numcoh,2)),numincoh,1) $
		    /(numincoh*numcoh^2)
	endelse
;
	v123=add(v1*conj(v2)*v3,numincoh,1)/(numincoh*numcoh^3)
	hds_close
;
	hds_open,confile,'UPDATE',status
	if status ne 0 then return
	dat_find,'SCANDATA'
	dat_find,'POINTDATA'
	dat_cell,1,i+1
	dat_find,'OUTPUTBEAM'
;
	name='VISSQ'
	ndim=3
	type='_real'
	dat_cell,1,1
	dims=[genconfig.numspecchan[0],1,np[i]]
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,vsq1
	dat_annul
	dat_cell,1,2
	dims=[genconfig.numspecchan[1],1,np[i]]
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,vsq2
	dat_annul
	dat_cell,1,3
	dims=[genconfig.numspecchan[2],1,np[i]]
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,vsq3
	dat_annul
;
	dat_annul
;
	dat_find,'TRIPLE'
;
	name='COMPLTRIPLE'
	ndim=3
	type='_real'
	dat_cell,1,1
	dims=[2,genconfig.numspecchan[0],np[i]]
	data=fltarr(dims[0],dims[1],dims[2],/nozero)
	data[0,*,*]=float(v123)
	data[1,*,*]=imaginary(v123)
	dat_there,name,reply & if reply eq 1 then dat_erase,name
	dat_new,name,type,ndim,dims
	cmp_putnr,name,ndim,dims,data
;
	hds_close
;
	ENDIF ELSE hds_close
;
endfor
;
hds_open,confile,'UPDATE',status
if status ne 0 then return
dat_find,'SCANDATA'
;
name='NUMCOH'
dat_erase,name
type='_integer'
ndim=1
dims[0]=n
dat_new,name,type,ndim,dims
cmp_put1i,name,numcohs
;
name='NUMINCOH'
dat_erase,name
type='_integer'
ndim=1
dims[0]=n
dat_new,name,type,ndim,dims
cmp_put1i,name,numincohs
;
hds_close
;
end
