pro contourbeam,star
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Plot contours of dirty beam.
;
common BeamInfo,reduce
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
beam=dirtybeam(star)
if beam[0] eq -1 then return
;
imsize=n_elements(beam[0,*])
x=(findgen(imsize)-imsize/2)*(180/!pi)/(imsize*reduce)*3600e3
y=x
plevels=[5,10,20,50,80]
nlevels=[-80,-50,-20,-10,-5]
levels=[nlevels,plevels]
levels_label=''
for i=0,n_elements(levels)-1 do $
	levels_label=levels_label+string(levels[i],format='(i4)')
contour,beam,x,y,levels=plevels*max(beam)/100,xstyle=1,ystyle=1, $
	xtitle='Contours: '+levels_label+' % of peak',ytitle='[mas]', $
	title='Dirty beam for '+star+' on '+date
contour,beam,x,y,levels=nlevels*max(beam)/100,c_linestyle=1,/overplot
oplot,[0,0],[y[0],y[imsize-1]],psym=0,linestyle=1
oplot,[x[0],x[imsize-1]],[0,0],psym=0,linestyle=1
;
end
