function corrloss,tau
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the correlation loss factor (Davis & Tango 1996) for
; tau=dt/t0, t0 being the coherence time and dt the sampling time.
;
index=where(tau eq 0,count)
if count gt 0 then tau[index]=1
t=double(tau)
x=t^(5.d0/3.d0)
a1=3.d0/5.d0
a2=6.d0/5.d0
r=tau
for i=0,n_elements(tau)-1 do $
	r[i]=(a2/t[i])*(gamma(a1)*igamma(a1,x[i]) $
                       -gamma(a2)*igamma(a2,x[i])/t[i])
if count gt 0 then r[index]=1
return,r
;
end
