pro create_calentries,num_e
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Set available indicators and functions. Indicators are referenced by sequence
; number in set_caldata! Functions are also used by other fit-routines.
; Create and initialize array of cal_entry structures.
;
common BaseFunctions,numlist,functions
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common CalInfo,cal_entries
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
functions=[ $
	'1', $
	'x', $
	'x^2', $
	'x^3', $
	'x^4', $
;
	'L_0', $
	'L_1', $
	'L_2', $
	'L_3', $
	'L_4', $
;
	'P_0', $
	'P_1', $
	'P_2', $
	'   ', $
	'   ', $
;
	'S_10', $
	'S_20', $
	'S_40', $
	'S_60', $
	'S_80' $
	]
num_f=n_elements(functions)
numlist=[5,5,5,5]
;
indicators=[ $
	'Wavelength', $
	'DelayJitter', $
	'TrackJitter', $
	'ZenithAngle', $
	'MirrorAngle', $
	'HourAngle', $
	'Time']
num_i=n_elements(indicators)
;
num_t=num_i*num_f	; Maximum number of terms
;
list_stars,stars
num_st=n_elements(stars)
;
num_sc=n_elements(scanconfig(scanconfig()))
;
if n_elements(num_e) eq 0 then $
	num_e=(long(total(GenConfig.NumBaseline*GenConfig.NumSpecChan)) $
	      +long(total(GenConfig.TripleNumChan*2)))*num_st
num_e=max([num_e,10])
;
cal_entries=alloc_cal_entries(num_f,num_i,num_t,num_st,num_sc,num_e)
;
end
