pro create_cri,request,i1,i2
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given arrays of corresponding catalog numbers (may contain zeroes), create
; crossindex tables for request in both directions and save to disk files.
;
;
flag=0
if n_elements(request) eq 0 then flag=1
ni1=n_elements(i1)
ni2=n_elements(i2)
if ni1 ne ni2 or ni1 eq 0 then flag=1
if flag then begin
	print,'***Error(CREATE_CRI): insufficient input!'
	return
endif
index=where(i1 ne 0 and i2 ne 0,count)
if count eq 0 then begin
	print,'***Error(CREATE_CRI): indices empty!'
	return
endif
t=build_critable(i1[index],i2[index])
;
if criparse(request,cat_1,cat_2) ne -1 then begin
	index=sort(t.id1) & t=t[index]
	index=uniq(t.id1) & t=t[index]
	file=!catalogs_dir+'crossindex/'+cat_1+'_'+cat_2+'.cri'
	save,t,filename=file
	id1=t.id2 & id2=t.id1 & t.id1=id1 & t.id2=id2
	index=sort(t.id1) & t=t[index]
	index=uniq(t.id1) & t=t[index]
	file=!catalogs_dir+'crossindex/'+cat_2+'_'+cat_1+'.cri'
	save,t,filename=file
endif
;
; Changed print below by Bob to output cross-index created and increase
; the integer size printed to accomodate the large number of
; entries in the SAO catalog.
;
print,'Saved crossindex; ',request,' number of entries=',n_elements(t),'.', $
	format='(a,a,a,i6,a)'
;
end
