pro create_startable,star_ids_in,quiet=quiet,ra_in=ra,dec_in=dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; In call, use ra_in=ra with, e.g., ra='07:32:12.1' to set ra
; In call, use dec_in=dec with, e.g., dec='-16:58:24.64' to set dec
;
; Create and initialize StarTable.
;
common StarBase,StarTable,Notes
;
if strlen(star_ids_in[0]) gt 0 then begin
	star_ids=oyster_starid(star_ids_in,quiet=quiet)
endif else begin
;	Define star just by coordinates
	star_ids=''
	if n_elements(ra) eq 0 or n_elements(dec) eq 0 then begin
		print,'Error: if StarId undefined, please specify RA & Dec!'
		return
	endif
	if n_elements(ra) ne n_elements(dec) then begin
		print,'Error: RA has not the same size as DEC!'
		return
	endif
	star_ids=strarr(n_elements(ra))
	ra_in=ra
	dec_in=dec
endelse
;
numstars=n_elements(star_ids)
;
maxwaves=100
;
starid=strarr(numstars)		; StarId (e.g. BSC1708)
starid[*]=star_ids
;
; Allocate arrays
name=strarr(numstars)		; Star name (20 chars)
; name(*)='                    '
var=strarr(numstars)		; Variable name (10 chars)
; var(*)='          '
;
; toe=strarr(numstars)		; Proper name (40 chars)
; toe(*)='                                        '
;
ra=dblarr(numstars)		; Right Ascension [h]
rae=fltarr(numstars)		; Right Ascension error [h]
dec=dblarr(numstars)		; Declination [deg]
dece=fltarr(numstars)		; Declination error [deg]
;
bat=intarr(numstars)		; Batten catalogue number
fkv=intarr(numstars)		; FK5 number
bsc=intarr(numstars)		; HR number
fln=intarr(numstars)		; Finding list number
ads=intarr(numstars)		; ADS number
hdn=lonarr(numstars)		; HD number
hic=lonarr(numstars)		; HIPPARCOS input catalogue number
sao=lonarr(numstars)		; SAO number
wds=lonarr(numstars)		; WDS number
;
mv=fltarr(numstars)+100		; Johnson V, combined if double
av=fltarr(numstars)		; Visual extinction
mj=fltarr(numstars)+100		; Johnson J, combined if double
mh=fltarr(numstars)+100		; Johnson H, combined if double
mk=fltarr(numstars)+100		; Johnson K, combined if double
flp=fltarr(numstars)		; 3.8 micron Lp flux [Jansky]
f12=fltarr(numstars)		; 12 micron N-band flux [Jansky]
bv=fltarr(numstars)+100		; (B-V), combined if double
ub=fltarr(numstars)+100		; (U-B), combined if double
ri=fltarr(numstars)+100		; (R-I), combined if double
dmv=fltarr(numstars)+100	; V magnitude difference
amv=fltarr(numstars)+100	; Absolute V magnitude, combined if double
;
by=fltarr(numstars)+100		; Stroemgren (b-y)
m1=fltarr(numstars)+100		; Stroemgren m1
c1=fltarr(numstars)+100		; Stroemgren c1
beta=fltarr(numstars)+100	; Stroemgren Beta index
feh=fltarr(numstars)+100	; [Fe/H]
;
pmra=fltarr(numstars)		; Cent. Proper motion in RA [s]
pmrae=fltarr(numstars)		; Cent. Proper motion error in RA [s]
pmdec=fltarr(numstars)		; Cent. Proper motion in DEC ["]
pmdece=fltarr(numstars)		; Cent. Proper motion error in DEC ["]
rv=fltarr(numstars)		; mean radial velocity [km/s]
vsini=fltarr(numstars)		; rotational velocity [km/s]
px=fltarr(numstars)		; Parallax ["]
pxe=fltarr(numstars)+0.01	; Parallax error ["]; default to 10 mas
d=fltarr(numstars)		; Distance [pc]
;
spectrum=strarr(numstars)	; Spectral class [MK]
; spectrum(*)='                              '
type=fltarr(numstars)		; Spectral type (primary)
type2=fltarr(numstars)		; Spectral type (secondary)
class=fltarr(numstars)		; Luminosity class (primary)
class2=fltarr(numstars)		; Luminosity class (secondary)
sed=fltarr(maxwaves,numstars)	; Flux
wvl=fltarr(maxwaves,numstars)	; Wavelengths [microns]
teff=fltarr(numstars)		; Effective temperature [K] (primary)
teff2=fltarr(numstars)		; Effective temperature [K] (secondary)
logg=fltarr(numstars)		; log(g) [cgs] (primary)
logg2=fltarr(numstars)		; log(g) [cgs] (secondary)
;
p=fltarr(numstars)		; Orbital period [d]
t=dblarr(numstars)		; Epoch [JD]
o=fltarr(numstars)		; Argument of periastron [deg]
e=fltarr(numstars)		; Eccentricity
i=fltarr(numstars)		; Inclination [deg]
n=fltarr(numstars)		; Argument of ascending node [deg]
a=fltarr(numstars)		; Semi-major axis ["]
k1=fltarr(numstars)		; [km/s]
k2=fltarr(numstars)		; [km/s]
mf=fltarr(numstars)		; Mass function for single-lined binaries
m1sin3i=fltarr(numstars)
m2sin3i=fltarr(numstars)
a1sini=fltarr(numstars)		; [km/s]
a2sini=fltarr(numstars)		; [km/s]
;
diameter=fltarr(numstars)	; [mas]; polar diameter for rotating stars
diameter2=fltarr(numstars)	; [mas]
omega=fltarr(numstars)		; Rotational angular rate in units of breakup
tilt=fltarr(numstars)		; tilt of rotation axis, 90 = orthogonal
rapa=fltarr(numstars)		; PA of rotation axis on sky
zexp=fltarr(numstars)+0.25	; van Zeipel exponent, default=0.25
zerospacing=fltarr(numstars)	; Zero spacing visibility
a0=fltarr(numstars)		; Linear limb darkening fit coefficient
a1=fltarr(numstars)		; Linear limb darkening fit coefficient
a2=fltarr(numstars)		; Linear limb darkening fit coefficient
mass=fltarr(numstars)		; [M_sun]
mass2=fltarr(numstars)		; [M_sun]
;
bflag=strarr(numstars)+'.'	; Binary/calibrator flag, '.','B','C'
hflag=strarr(numstars)+' '	; Hipparcos double/multiple systems flag:
;    C : solutions for the components
;    G : acceleration or higher order terms
;    O : orbital solutions
;    V : variability-induced movers (apparent motion arises from variability)
;    X : stochastic solution (probably astrometric binaries with short period)
vflag=strarr(numstars)+' '	; Hipparcos variability flag:
;    C : no variability detected ("constant")
;    D : duplicity-induced variability
;    M : possibly micro-variable (amplitude < 0.03mag)
;    P : periodic variable
;    R : V-I colour index was revised due to variability analysis
;    U : unsolved variable which does not fall in the other categories
sflag=strarr(numstars)+'OK'	; Status/consistency flag; '!' if bad
;
model=strarr(numstars)		; e.g. UDK, LD, etc...
reference=strarr(numstars)	; Reference
;
StarTable=build_startable(starid,name,var,ra,rae,dec,dece, $
	mv,av,mj,mh,mk,flp,f12,bv,ub,ri,dmv,amv,by,m1,c1,beta, $
	diameter,diameter2,omega,tilt,rapa,zexp, $
	zerospacing,a0,a1,a2,mass,mass2,feh, $
	pmra,pmrae,pmdec,pmdece,rv,vsini,px,pxe,d, $
	spectrum,type,type2,class,class2,sed,wvl, $
	teff,teff2,logg,logg2, $
	p,t,o,e,i,n,a,k1,k2,mf,m1sin3i,m2sin3i,a1sini,a2sini, $
	bflag,hflag,vflag,sflag,model,reference)
;
if not keyword_set(quiet) then $
print,'StarTable created; number of entries = ',numstars,'.',format='(a,i6,a)'
;
; If call used coordinates, update these in the StarTable
if strlen(starid[0]) eq 0 then begin
	StarTable.ra=hms2h(ra_in)
	StarTable.dec=dms2d(dec_in)
;	Restore inputs
	ra=ra_in
	dec=dec_in
endif
;
end
