function cri,id0,request,lists=lists
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return id2 of star with id1=id0 according to requested crossindex.
; Examples: print,cri(123,'fkv-bsc); print,cri('Capella','hic')
; Please note that 'hic' is used instead of 'hip' for Hipparcos catalog.
;
forward_function cri
;
greek_alphabet=['ALF','ALP','BET','GAM','DEL','EPS','ZET','ETA','THE','TET', $
		'IOT','KAP','LAM', 'MU', 'NU', 'XI','OMI', 'PI','RHO','SIG', $
		'TAU','UPS','PHI','CHI','PSI','OME']
;
if n_params() ne 2 then begin
	print,'***Error(CRI): wrong number of parameters!'
	return,-1
endif
num_id=n_elements(id0)
if num_id eq 0 then begin
	print,'***Error(CRI): id undefined!'
	return,-1
endif else id1=id0
if n_elements(request) eq 0 then begin
	print,'***Error(CRI): request not specified!'
	return,-1
endif else request=strlowcase(request)
;
; If lists=1 search only in verbose lists
if n_elements(lists) eq 0 then lists=0
;
; Replace HDN and BSC with HD and HR catalog identifier which are detected below
index=where(strmid(id1,0,3) eq 'HDN',count)
if count gt 0 then $
	id1[index]='HD'+string(strmid(id1[index],3,6),format='(i6.6)')
index=where(strmid(id1,0,3) eq 'BSC',count)
if count gt 0 then $
	id1[index]='HR'+string(strmid(id1[index],3,4),format='(i4.4)')
;
id2=lonarr(num_id)-1
c2=strarr(num_id)
;
; Special feature: ID for name, e.g. print,cri('Capella','hic')
r=size(id1)
if r[n_elements(r)-2] eq 7 then begin
;	Remove blanks, dashes, underscores in name for search in verbose lists
	if lists then $
	for i=0,num_id-1 do if strpos(id1[i],'OBJ') lt 0 then $
		id1[i]=strjoin(nameparse(id1[i],['+','-','_',' ']))
	jndex=where(isnumeric(strmid(id1,2)) eq 1)
;	Two-letter catalog names (HD/HR), allow blank between cat and ID
	index=where(strupcase(strmid(id1,0,2)) eq 'HD' and $
		    isnumeric(strmid(id1,2)) eq 1,count)
	if count gt 0 and request eq 'hdn' then $
	id2[index]=long(strmid(id1[index],2,7))
	if count gt 0 and request eq 'bsc' then $
	id2[index]=cri(long(strmid(id1[index],2,7)),'hdn-bsc')
	index=where(strupcase(strmid(id1,0,2)) eq 'HR' and $
		    isnumeric(strmid(id1,2)) eq 1,count)
	if count gt 0 and request eq 'bsc' then $
	id2[index]=long(strmid(id1[index],2,5))
	if count gt 0 and request eq 'hdn' then $
	id2[index]=cri(long(strmid(id1[index],2,5)),'bsc-hdn')
;
	file=!oyster_dir+'starbase/vlti.hdn'
	result=file_search(file,count=fcount)
	if fcount ne 0 then begin
		hdn=0
		toes=''
		s=dc_read_fixed(file,hdn,toes,/col,ignore=['!'], $
			format='(i6,a32)')
		for i=0,num_id-1 do begin
			words=strupcase(nameparse(id1[i]))
			si=sort(words) & words=words[reverse(si)]
			for j=0,n_elements(toes)-1 do begin
			l=0
			name=toes[j]
			for k=0,n_elements(words)-1 do begin
			m=strpos(strupcase(name),words[k],0)
			if m ne -1 then begin
				strput,name,blanks(strlen(words[k])),m
				l=l+1
			endif
			endfor
			if l eq n_elements(words) $
				and strlen(strcompress(toes[j],/remove_all))  $
			 	eq fix(total(strlen(words))) $
			  	then begin
					id2[i]=hdn[j]
					c2[i]='HDN'
			endif
			endfor
		endfor
	endif
	file=!oyster_dir+'starbase/vlti.bsc'
	result=file_search(file,count=fcount)
	if fcount ne 0 and total(id2 ge 0) lt num_id then begin
		bsc=0
		toes=''
		s=dc_read_fixed(file,bsc,toes,/col,ignore=['!'], $
			format='(i4,a32)')
		for i=0,num_id-1 do begin
			words=strupcase(nameparse(id1[i]))
			si=sort(words) & words=words[reverse(si)]
			for j=0,n_elements(toes)-1 do begin
			l=0
			name=toes[j]
			for k=0,n_elements(words)-1 do begin
			m=strpos(strupcase(name),words[k],0)
			if m ne -1 then begin
				strput,name,blanks(strlen(words[k])),m
				l=l+1
			endif
			endfor
			if l eq n_elements(words) $
				and strlen(strcompress(toes[j],/remove_all))  $
			 	eq fix(total(strlen(words))) $
			  	then begin
					id2[i]=bsc[j]
					c2[i]='BSC'
				endif
			endfor
		endfor
	endif
	file=!oyster_dir+'starbase/vlti.hic'
	result=file_search(file,count=fcount)
	if fcount ne 0 and total(id2 ge 0) lt num_id then begin
		hic=0
		toes=''
		s=dc_read_fixed(file,hic,toes,/col,ignore=['!'], $
			format='(i6,a32)')
		for i=0,num_id-1 do begin
			words=strupcase(nameparse(id1[i]))
			si=sort(words) & words=words[reverse(si)]
			for j=0,n_elements(toes)-1 do begin
			l=0
			name=toes[j]
			for k=0,n_elements(words)-1 do begin
			m=strpos(strupcase(name),words[k],0)
			if m ne -1 then begin
				strput,name,blanks(strlen(words[k])),m
				l=l+1
			endif
			endfor
			if l eq n_elements(words) $
				and strlen(strcompress(toes[j],/remove_all))  $
			 	eq fix(total(strlen(words))) $
			  	then begin
					id2[i]=hic[j]
					c2[i]='HIC'
			endif
			endfor
		endfor
	endif
	file=!oyster_dir+'starbase/vlti.usr'
	result=file_search(file,count=fcount)
	if fcount ne 0 and total(id2 ge 0) lt num_id then begin
		usr=0
		toes=''
		s=dc_read_fixed(file,usr,toes,/col,ignore=['!'], $
			format='(i4,a32)')
		for i=0,num_id-1 do begin
		words=strupcase(nameparse(id1[i]))
		si=sort(words) & words=words[reverse(si)]
		for j=0,n_elements(toes)-1 do begin
			l=0
			name=toes[j]
			for k=0,n_elements(words)-1 do begin
			m=strpos(strupcase(name),words[k],0)
			if m ne -1 then begin
				strput,name,blanks(strlen(words[k])),m
				l=l+1
			endif
			endfor
			if l eq n_elements(words) $
				and strlen(strcompress(toes[j],/remove_all))  $
			 	eq fix(total(strlen(words))) $
		   		then begin
					id2[i]=usr[j]
					c2[i]='USR'
			endif
			endfor
		endfor
	endif
	file=!oyster_dir+'starbase/toe.bsc'
	result=file_search(file,count=fcount)
	if fcount ne 0 and total(id2 ge 0) lt num_id then begin
		bsc=0
		toes=''
		s=dc_read_fixed(file,bsc,toes,/col,ignore=['!'], $
			format='(i4,a32)')
		for i=0,num_id-1 do begin
			words=strupcase(nameparse(id1[i]))
			si=sort(words) & words=words[reverse(si)]
			for j=0,n_elements(toes)-1 do begin
			l=0
			name=toes[j]
			for k=0,n_elements(words)-1 do begin
			m=strpos(strupcase(name),words[k],0)
			if m ne -1 then begin
				strput,name,blanks(strlen(words[k])),m
				l=l+1
			endif
			endfor
			if l eq n_elements(words) $
				and strlen(strcompress(toes[j],/remove_all))  $
			 	eq fix(total(strlen(words))) $
				and id2[i] eq -1 $
			   	then begin
					id2[i]=bsc[j]
					c2[i]='BSC'
			endif
			endfor
		endfor
	endif
	file=!oyster_dir+'starbase/var.bsc'
	result=file_search(file,count=fcount)
	if fcount ne 0 and total(id2 ge 0) lt num_id then begin
		bsc=0
		vars=''
		s=dc_read_free(file,bsc,vars,/col,ignore=['!'])
		for i=0,num_id-1 do begin
			words=strupcase(nameparse(id1[i]))
			si=sort(words) & words=words[reverse(si)]
			for j=0,n_elements(vars)-1 do begin
			l=0
			name=vars[j]
			for k=0,n_elements(words)-1 do begin
			m=strpos(strupcase(name),words[k],0)
			if m ne -1 then begin
				strput,name,blanks(strlen(words[k])),m
				l=l+1
			endif
			endfor
			if l eq n_elements(words) $
				and strlen(strcompress(vars[j],/remove_all))  $
			 	eq fix(total(strlen(words))) $
				and id2[i] eq -1 $
			   	then begin
					id2[i]=bsc[j]
					c2[i]='BSC'
			endif
			endfor
		endfor
	endif
;	Search name.bsc for Flamsteed/Bayer names (lists=0)
	file=!oyster_dir+'starbase/name.bsc'
	result=file_search(file,count=fcount)
	if fcount ne 0 and total(id2 ge 0) lt num_id and not lists then begin
		bsc=0
		names=''
		s=dc_read_free(file,bsc,names,/col,ignore=['!'])
		for i=0,num_id-1 do begin
			words=reverse(strupcase(nameparse(id1[i],[' ','-','_'])))
			if n_elements(words) eq 2 then begin
			for j=0,n_elements(names)-1 do begin
			l=0
			name=names[j]
			if isnumeric(strmid(name,0,1)) $
				then flamsteed=fix(name) $
				else flamsteed=0
			for k=0,n_elements(words)-1 do begin
			m=strpos(name,strmid(words[k],0,3),/reverse_search)
			if flamsteed ne 0 and isnumeric(words[k]) then $
				if fix(words[k]) ne flamsteed then m=-1
			if k eq 1 and not isnumeric(words[k]) then begin
				index=where(greek_alphabet eq words[k],count)
				if count eq 0 then m=-1
			endif
			if m ne -1 then begin
				l=l+1
				for n=1,strlen(words[k]) do $
					strput,name,' ',m+n-1
			endif
			endfor
			if l eq n_elements(words) $
				and strlen(names[j]) $
				ge fix(total(strlen(words))) $
				and id2[i] eq -1 $
			then begin
				id2[i]=bsc[j]
				c2[i]='BSC'
			endif
			endfor
			endif
		endfor
	endif
	if request eq 'bsc' then begin
		index=where(c2 eq 'HIC' or c2 eq 'HIP',count)
		if count gt 0 then id2[index]=cri(id2[index],'hic-bsc')
		index=where(c2 eq 'HDN',count)
		if count gt 0 then id2[index]=cri(id2[index],'hdn-bsc')
		index=where(c2 eq 'USR',count)
		if count gt 0 then id2[index]=-1
		return,id2
	endif else if request eq 'hic' or request eq 'hip' then begin
		index=where(c2 eq 'BSC',count)
		if count gt 0 then id2[index]=cri(id2[index],'bsc-hic')
		index=where(c2 eq 'HDN',count)
		if count gt 0 then id2[index]=cri(id2[index],'hdn-hic')
		index=where(c2 eq 'USR',count)
		if count gt 0 then id2[index]=-1
		return,id2
	endif else if request eq 'hdn' then begin
		index=where(c2 eq 'FKV',count)
		if count gt 0 then id2[index]=cri(id2[index],'fkv-hdn')
		index=where(c2 eq 'BSC',count)
		if count gt 0 then id2[index]=cri(id2[index],'bsc-hdn')
		index=where(c2 eq 'HIC' or c2 eq 'HIP',count)
		if count gt 0 then id2[index]=cri(id2[index],'hic-hdn')
		index=where(c2 eq 'USR',count)
		if count gt 0 then id2[index]=-1
		return,id2
	endif else if request eq 'fkv' then begin
		index=where(c2 eq 'BSC',count)
		if count gt 0 then id2[index]=cri(id2[index],'bsc-fkv')
		index=where(c2 eq 'HIC' or c2 eq 'HIP',count)
		if count gt 0 then id2[index]=cri(id2[index],'hic-fkv')
		index=where(c2 eq 'USR',count)
		if count gt 0 then id2[index]=-1
		return,id2
	endif else if request eq 'usr' then begin
		index=where(c2 eq 'HDN',count)
		if count gt 0 then id2[index]=-1
		index=where(c2 eq 'BSC',count)
		if count gt 0 then id2[index]=-1
		index=where(c2 eq 'HIC' or c2 eq 'HIP',count)
		if count gt 0 then id2[index]=-1
		index=where(c2 eq 'FKV',count)
		if count gt 0 then id2[index]=-1
		return,id2
	endif else if request eq 'cat' then begin
		request=c2
		return,id2
	endif
endif	; Special feature: ID for name
;
if criparse(request,cat_1,cat_2) ne -1 then begin
        file=!catalogs_dir+'crossindex/'+cat_1+'_'+cat_2+'.cri'
        result=file_search(file,count=fcount)
        if fcount ne 0 then restore,filename=file else begin
                print,'***Error(CRI): file not found: ',file,'!'
                return,-1
        endelse
endif else return,-1
;
num_t=n_elements(t)
if num_id gt num_t/30L then begin
	s=sort(id1)
	id1_s=id1[s]
	id2_s=id2
	j=0L
	for i=0L,num_t-1L do begin
		while t[i].id1 gt id1_s[j] and j lt num_id-1L do j=j+1L
		while t[i].id1 eq id1_s[j] and j lt num_id-1L do begin
			id2_s[j]=t[i].id2
			j=j+1L
		endwhile
		if t[i].id1 eq id1_s[j] then id2_s[j]=t[i].id2
	endfor
	id2[s]=id2_s
endif else begin
	for i=0L,num_id-1L do begin
		index=where(t.id1 eq id1[i],count)
		if count ne 0 then id2[i]=t[index[0]].id2
	endfor
endelse
;
if n_elements(id2) eq 1 then return,id2[0] else return,id2
;
end
