function cri_simbad,target0,table
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Query SIMBAD using either lynx or elinks (wget could be used too?) to find
; target by coordinates or identifier. In the first case, return name of star
; if found, in the second case return OYSTER StarId if found in HD catalog.
;
; Examples for target:
; '09 47 57.382 +13 16 43.66'
; 'OBJ+000556692434080'
; 'HD 100'
;
; If argument "table" is passed, it will contain the startable on return.
; Any existing StarTable before calling this function will not be touched.
;
common StarBase,StarTable,Notes
;
if n_elements(StarTable) ne 0 then StarTable_backup=StarTable
;
table={starid:'',name:'',hdn:0l,ra:0.d0,dec:0.d0,pmra:0.d0,pmdec:0.d0, $
;   spectrum:'',mb:0.0,mv:0.0,mj:0.0,mh:0.0,mk:0.0,bv:0.0,ub:0.0,px:0.0,pxe:0.0}
    spectrum:'',       mv:0.0,mj:0.0,mh:0.0,mk:0.0,bv:0.0,ub:0.0,px:0.0,pxe:0.0}
;
; Allocate full OYSTER StarTable instead to help potential merging of tables
create_startable,target0,/quiet
table=startable
;
; Restore StarTable
if n_elements(StarTable_backup) ne 0 then StarTable=StarTable_backup
;
; What text browser is available
browser='elinks -dump '
browser='lynx -dump '
;
star=''
;
; Check if target has 2 elements, RA, Dec
words=nameparse(target0)
if n_elements(words) eq 2 then begin
	ra=nameparse(words[0],':')
	dec=nameparse(words[1],':')
	if n_elements(ra) eq 3 and n_elements(dec) eq 3 then begin
		ra=strjoin(ra,' ')
		dec=strjoin(dec,' ')
		target0=ra+' '+dec
	endif
endif
;
; Lookup by coordinates
if n_elements(nameparse(target0)) gt 2 or strpos(target0,'OBJ') ge 0 then begin
	lookup_call='coordinate'
	if strpos(target0,'OBJ') ge 0 then begin
		target=esopos(target0)
		words=[hms(target[0],/aspro),dms(target[1],/aspro)]
	endif else begin
		words=nameparse(target0)
	endelse
	if n_elements(words) gt 2 then begin
		ra=strjoin(words[0:2],':')
		dec=strjoin(words[3:5],':')
	endif else begin
		ra=words[0]
		dec=words[1]
	endelse
	words=nameparse(ra,':')
	ra=strjoin(words,'+')
	words=nameparse(dec,':')
	dec=strjoin(words,'+')
	if strpos(dec,'-') ge 0 then begin
		c='-'
	endif else begin
		c='%2B'
	endelse
	dec=strmid(dec,1,15)
;	Simbad4 call (using scripts)
	simbad='http://simweb.u-strasbg.fr/simbad/'
	script='sim-script?submit=submit+script&script='
	spawn,browser+'"'+simbad+script+ra+'+'+c+dec+'"',r
	jl=where(strpos(r,'liste identificateurs') ge 0,count)
	starid=''	; OYSTER starid
	for il=0,count-1 do begin
;               Accept all matches closer than 3"
		i=0
		repeat begin
			i=i+1
			words=nameparse(r[jl[il]-i])
		endrep until strpos(words[0],'dist') ge 0
		if float(words[1]) lt 3.0 then begin
;               	We return only HIC and HD
			k=strpos(r[jl[il]],'(')
			n=long(strmid(r[jl[il]],k+1,2))
			identifiers=r[jl[il]+1:jl[il]+n]
			star=identifiers[0]
;			k=where(strpos(identifiers,'2MASS') ge 0) & k=k(0)
;			if k ge 0 then star=identifiers(k)
;			k=where(strpos(identifiers,'IRAS') ge 0) & k=k(0)
;			if k ge 0 then star=identifiers(k)
;			k=where(strpos(identifiers,'IRC') ge 0) & k=k(0)
;			if k ge 0 then star=identifiers(k)
			k=where(strpos(identifiers,'HIC ') ge 0) & k=k[0]
			if k ge 0 then starid=identifiers[k]
			k=where(strpos(identifiers,'HIP ') ge 0) & k=k[0]
			if k ge 0 then starid=identifiers[k]
			k=where(strpos(identifiers,'HD ') ge 0) & k=k[0]
			if k ge 0 then starid=identifiers[k]
		endif
	endfor
	if strlen(starid) ne 0 then star=starid
	if count eq 0 then return,''
endif else begin
; 	Lookup by identifier
	lookup_call='identifier'
	words=nameparse(target0)
	if strpos(target0,'HDN') ge 0 then words=['HD',strmid(target0,3,6)]
	if strpos(target0,'HIC') ge 0 then words=['HIC',strmid(target0,3,6)]
	if strpos(target0,'HIP') ge 0 then words=['HIC',strmid(target0,3,6)]
	target=strjoin(words,'+')
;	Simbad4 call (using scripts)
	simbad='http://simweb.u-strasbg.fr/simbad/'
	script='sim-script?submit=submit+script&script=query+id+'
	spawn,browser+'"'+simbad+script+target+'"',r
	j=where(strpos(r,'liste identificateurs') ge 0,count) & j=j[0]
	if count ge 1 then begin
;               SIMBAD found the target
		k=strpos(r[j],'(')
		n=long(strmid(r[j],k+1,2))
		identifiers=r[j+1:j+n]
		k=where(strpos(identifiers,'HD ') ge 0) & k=k[0]
		if k ge 0 then begin
;			HD identifier
			words=nameparse(identifiers[k])
			table.hdn=long(words[1])
			table.starid='HDN'+string(table.hdn,format='(i6.6)')
		endif
		star=table.starid
	endif else begin
		return,''
	endelse
;
endelse
;
; Coordinates
j=where(strpos(r,'coord') ge 0) & j=j[0]
words=nameparse(r[j],[':','('])
if strpos(words[1],'-') ge 0 then sign=-1 else sign=1
words=nameparse(words[1],['+','-'])
ra=strjoin(nameparse(words[0]),':')
dec=strjoin(nameparse(words[1]),':')
table.ra=hms2h(ra)
table.dec=dms2d(dec)*sign
;
; Proper motions
j=where(strpos(r,'proper motion') ge 0) & j=j[0]
if j[0] ge 0 then begin
words=nameparse(r[j],[':','['])
if n_elements(words) gt 1 then begin
	words=nameparse(words[1])
; 	Convert mas/year to arcsec/centennial
	if isnumeric(words[0]) $
	then table.pmra=(double(words[0])/150) $
				      /cos(table.dec*!pi/180)
	if isnumeric(words[1]) $
	then table.pmdec=double(words[1])/10
endif else begin
	table.pmra=0
	table.pmdec=0
endelse
endif
;
; Parallax
j=where(strpos(r,'parallax') ge 0) & j=j[0]
if j[0] ge 0 then begin
words=nameparse(r[j],[':','[',']'])
if n_elements(words) gt 1 then begin
	table.px=float(words[1])
	table.pxe=float(words[2])
endif else begin
	table.px=0
	table.pxe=0
endelse
endif
;
; Spectral type
j=where(strpos(r,'Spectral type') ge 0) & j=j[0]
if j ge 0 then begin
words=nameparse(r[j],':')
if n_elements(words) gt 1 then begin
	words=nameparse(words[1])
	table.spectrum=strcompress(words[0],/remove_all)
endif else table.spectrum=''
endif
;
; Magnitudes
j=where(strpos(r,'flux: V (Vega)') ge 0) & j=j[0]
j=where(strpos(r,'flux: V') ge 0) & j=j[0]
if j ge 0 then begin
	if strpos(r[j],'Vega') ge 0 then $
	table.mv=float(strmid(r[j],15,10)) else $
	table.mv=float(strmid(r[j],8,10))
endif else table.mv=100
bv='NOK'
j=where(strpos(r,'flux: B') ge 0) & j=j[0]
if j ge 0 then begin
	if strpos(r[j],'Vega') ge 0 then $
	table.bv=float(strmid(r[j],15,10))-table.mv else $
	table.bv=float(strmid(r[j],8,10))-table.mv
;	table.mb=table.bv+table.mv
	bv='OK'
endif else table.bv=100
j=where(strpos(r,'flux: U') ge 0) & j=j[0]
if j ge 0 and bv eq 'OK' then begin
	if strpos(r[j],'Vega') ge 0 then $
	table.ub=float(strmid(r[j],15,10))-table.mb else $
	table.ub=float(strmid(r[j],8,10))-table.mb
endif else table.ub=100
j=where(strpos(r,'flux: J') ge 0) & j=j[0]
if j ge 0 then begin
	if strpos(r[j],'Vega') ge 0 then $
	table.mj=float(strmid(r[j],15,10)) else $
	table.mj=float(strmid(r[j],8,10))
endif else table.mj=100
j=where(strpos(r,'flux: H') ge 0) & j=j[0]
if j ge 0 then begin
	if strpos(r[j],'Vega') ge 0 then $
	table.mh=float(strmid(r[j],15,10)) else $
	table.mh=float(strmid(r[j],8,10))
endif else table.mh=100
j=where(strpos(r,'flux: K') ge 0) & j=j[0]
if j ge 0 then begin
	if strpos(r[j],'Vega') ge 0 then $
	table.mk=float(strmid(r[j],15,10)) else $
	table.mk=float(strmid(r[j],8,10))
endif else table.mk=100
;
case lookup_call of
	'coordinate':	begin
			table.name=star
			print,'Unknown StarId, please assign in StarTable!'
			return,star
			end
	'identifier':	begin
			table.name=target0
			return,target0
	       		end
endcase
;
end
