function cri_vlti,obstarg,ra,dec
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Tries to find HD, HIP, or USR ID for given star, if not successful,
; use the 'OBJ' identifier. Uses startable but restores original contents.
;
; Note that all ' ','+','-', and '_' are removed from the names!
;
common StarBase,StarTable,Notes
;
if n_elements(startable) ne 0 then startable_bck=startable
;
star=obstarg
hdn=-1
hic=-1
usr=-1
;
; Remove blanks, dashes, underscores...
if strpos(obstarg,'OBJ') lt 0 and strpos(obstarg,'BD') lt 0 then begin
	star=strjoin(nameparse(obstarg,[' ','+','-','_']))
endif else if strpos(obstarg,'OBJ') eq 0 and n_params() eq 1 then begin
	radec=esopos(obstarg)
	ra=radec[0]
	dec=radec[1]
endif
starid=''
;
; Remove leading CAL or SCI string
if strpos(star,'CAL') eq 0 then star=strmid(star,3)
if strpos(star,'SCI') eq 0 then star=strmid(star,3)
if strpos(star,'B02') eq 0 then star=strmid(star,3)
if strpos(star,'M05') eq 0 then star=strmid(star,3)
;
; Find HD number if possible...
if strupcase(strmid(star,0,3)) eq 'HDN' then hdn=long(strmid(star,3,6)) else $
if strupcase(strmid(star,0,2)) eq 'HD'  then hdn=long(strmid(star,2,6))
;
if strupcase(strmid(star,0,3)) eq 'SAO' then $
hdn=cri(long(strmid(star,3,6)),'sao-hdn')
;
if strupcase(strmid(star,0,3)) eq 'HIP' then $
hdn=cri(long(strmid(star,3,6)),'hic-hdn')
;
; If HD number not found with crossindices, look in lists...
if hdn le 0 then $
hdn=cri(star,'hdn',/lists) & hdn=hdn[0]
;
; No HD number available, check Hipparcos IDs...
if hdn le 0 then $
hic=cri(star,'hic',/lists) & hic=hic[0]
;
; Extract USR ID, these stars have no HD, HIC/HIP, or other ID per definition...
if strupcase(strmid(star,0,3)) eq 'USR' then usr=long(strmid(star,3,4))
;
if hdn gt 0 then begin
        starid='HDN'+string(hdn,format='(i6.6)')
endif else if hic gt 0 then begin
        starid='HIP'+string(hic,format='(i6.6)')
endif else if usr gt 0 then begin
        starid='USR'+string(usr,format='(i4.4)')
endif else begin
        usr=cri(star,'usr',/lists) & usr=usr[0]
        if usr gt 0 then begin
                starid='USR'+string(usr,format='(i4.4)')
        endif else begin
		if n_elements(ra) ne 0 and n_elements(dec) ne 0 then $
; 			ESO ID format string, i.e. +HHMMSSFFDDMMSSF
		starid='OBJ'+esoid(ra,dec)
;		starid=obstarg
        endelse
endelse
;
if n_elements(startable_bck) ne 0 then startable=startable_bck
if n_elements(starid) eq 1 then starid=starid[0]
;
return,starid
;
end
