function cycles_per_arcsec,input,cycles=cycles,mlambda=mlambda
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Converts cycles per arcseconds to procjected baseline length [M lambda]
; and vice versa.
;
output=input
;
; These input values are  projected baseline lengths in millions of wavelengths
index=where(input ne 0,count)
if keyword_set(mlambda) then begin
	output[index]=3600./(atan(1e6/input[index])*180/!pi)
	return,output
endif
;
; These input values are spatial frequencies in cycles/arcsec
if keyword_set(cycles) then begin
	output[index]=(1./tan((1./(input[index]*3600))*!pi/180))/1e6
	return,output
endif
;
return,'Please use keywords /cycles or /mlambda for type of input!'
;
end
