pro d_stars
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute distance d[pc] from parallax, absolute magnitude,
; or weighted average of both, if available.
;
common StarBase,StarTable,Notes
;
; Parallax only
index=where((StarTable.px gt 0) $
	and (StarTable.amv eq +100),count)
if count gt 0 then StarTable[index].d=1./StarTable[index].px
;
; Absolute magnitude only
index=where((StarTable.px le 0) $
	and (StarTable.amv ne +100) $
	and (StarTable.mv ne +100),count)
if count gt 0 then $
	StarTable[index].d= $
		10^(((StarTable[index].amv-StarTable[index].mv)-5)/(-5))
;
; Weighted average of parallax and absolute magnitude (error assumed +/- 1 mag)
index=where((StarTable.px gt 0) $
	and (StarTable.amv ne +100) $
	and (StarTable.mv ne +100),count)
if count gt 0 then begin
	d_px=1./StarTable[index].px
	d_pxe=StarTable[index].pxe*d_px^2
	d_ph=10^(((StarTable[index].amv-StarTable[index].mv)-5)/(-5))
	d_phe=abs(d_ph)/5/alog(10)*1.0
	d_pxw=1/d_pxe^2
	d_phw=1/d_phe^2
	StarTable[index].d=(d_px*d_pxw+d_ph*d_phw)/(d_pxw+d_phw)
endif
;
end
