PRO datarequest,dummy,path=path
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Obsolete! Functionality implemented by datarequest.f in WDS directory.
;
; this program is written to fill wds data requests. The input is the 10 digit
; WDS coordinate. This will grab all multiple systems at a specified coordinate.
;
; output 1a ---> from WDS, each data line
; output 1b ---> explanation of codes from above
; output 1c ---> references from WDS
; output 1d ---> note from wdsnot.memo file
; output 1e ---> gif of measures                    *** NOT IMPLEMENTED YET ***
; output 2a ---> orbit parameters from orbit file
; output 2c ---> references from orbit file
; output 2d ---> note from orbit note file
; output 2e ---> gif of measures with orbit(s)      *** NOT IMPLEMENTED YET ***
; output 2f ---> ephemerides for next 10 years
; output 3a ---> delta-m measurements
; output 3b ---> delta-m codes
; output 3c ---> delta-m references
; output 4c ---> reference from note file           *** NOT IMPLEMENTED YET ***
;
; To Do : How do you handle astrometric binaries? They are not in the WDS, so
; don't triger anything. Should you do a strict coordinate search or add a
; summary line (with blanks for the data) and the appropriate codes? (N, O, D)?
;
; the routine is written in IDL so that adding the features in 1e and 2e can be
; done with the plotorb routines. Also, outputs 1e, 2d, 2e, 2f, 3a, 3b, 3c, 3d,
; and 4c can be implemented as available as they are not included in the old
; (v 1.0) data request output (which is non-functional due to the new dragon).
;
; set up arrays for checking references (algorithm by wih)
;
; Version 1.0  is the old hp-unix written by Geoff Douglass
; Version 2.0  is beta test IDL version (gives as much information as v 1.0)
; Version 2.1  gives Delta-m catalog information
; Version 2.2  reads from 5th Orbit Catalog
; Version 2.3  reads from 5th Orbit Catalog ephemerides file
; Version 2.4  reads correctly from the 5th Orbit Catalog ephemerides file
;              (Julian North <jnorth@suphys.physics.usyd.edu.au> pointed out
;              error in ephemerides of Alpha Cen - Not enough digits for sep
; Version 2.5  reads from 5th Orbit Catalog notes file
; Version 2.51 fixed error in orbit and note reading.
; Version 2.52 changed to reflect reformatting of delta-m file.
; Version 2.53 changed to reflect reformatting of reference file.
; Version 2.54 changed to 6th Orbit Catalog, etc. files
; Version 2.6  output includes precise position, when available.
; Version 2.7  works with new format wds data lines and single refcode.
; Version 2.71 output includes secondary proper motion, when available.
; Version 2.8  uses local copies of data files. Fake last lines are added to
;              these to avoid EOF errors.
; Version 2.9  reads "M" same as an "O" in column 80. This will eventually give
;              way to reading it as an "O" and a "L" once the "L" code is ready
;              for data requests.
; Version 3.0  Reads new format of orbit ephemeris file (when did it change? I
;              don't know). Correctly interpret dates in summary line.
print, ' '
print, ' DATAREQUEST.PRO: WDS (and associated catalogs) data request software'
print, '      Version 3.0  (03/29/04)'
print, ' '
;
; set up arrays for checking references (algorithm by wih)
;
refflag   = strarr(20000)
refcode2  = strarr(20000)
ref1      = strarr(20000)
ref2      = strarr(20000)
tmpcode1  = ' '
tmpcode2  = ' '
tmpref1   = ' '
tmpref2   = ' '
for i=0,19999 do begin
   refflag[i] = '0'
   endfor
iref = -1
openr,4,path+'/wds/wdsref.memo'
while (not EOF(4)) do begin
   readf,4,tmpcode2,tmpref1,tmpref2,format='(a8,9x,a37,a60)'
   if (tmpcode1 ne '        ') then begin
      iref = iref+1
      refcode2[iref] = tmpcode2
      ref1[iref]     = tmpref1
      ref2[iref]     = tmpref2
      endif
   endwhile
close,4
; initialize some variables
wdscoord = string(10)
coord    = string(10)
dd       = string(7)
stuff    = string(86)
; read,' Enter the WDS coordinate of the system : ',wdscoord    ; commented by C
wdscoord=dummy                                                  ; added by CAH
; determine which WDS data file to open
     hour      = strmid(wdscoord,0,2)
     halfhr    = strmid(wdscoord,2,1)
     halfhrchk = fix(strmid(wdscoord,2,1))
     if (halfhrchk ge 3) then halfhr = '5'
     if (halfhrchk lt 3) then halfhr = '0'
filein = path+'/wds/wds'+hour+halfhr+'.data'
fileout1 = 'junk'+wdscoord+'.delete_me'
fileout2 = 'wds'+wdscoord+'.measures'
; read the wds data into the file "'junk'+wdscoord+'delete_me'"
openr,1,filein
openw,2,fileout1
while (not EOF(1)) do begin
   readf,1,coord,dd,stuff,format='(a10,a7,a86)'
   if (wdscoord eq coord) then printf,2,coord,dd,stuff, $
        format='(a10,a7,a86)'
endwhile
close,1
close,2
; read and format the measures into the file "'wds'+wdscoord+'.measures'"
openr,2,fileout1
openw,3,fileout2
printf,3,' '
printf,3,wdscoord,format='("WDS Star No. ",a10)'
printf,3,'======================='
printf,3,' '
; define a bunch of variables
coord    = string(10)    &     dd       = string(7)     &     comp     = string(
;date1    = integer(4)    &     date2    = integer(4)    &
n1       = string(1)
n2       = string(1)     &     pa1      = string(3)     &     pa2      = string(
sep1     = string(3)     &     n3       = string(1)     &     n4       = string(
n5       = string(1)     &     n6       = string(1)     &     maga1    = string(
maga2    = string(2)     &     magb1    = string(2)     &     magb2    = string(
n7       = string(1)     &     n8       = string(5)     &     n9       = string(
n10      = string(1)     &     n11      = string(1)     &     n12      = string(
n13      = string(2)     &     n14      = string(4)     &     dm       = string(
n15      = string(1)     &     n16      = string(1)     &     n17      = string(
notcoord = string(10)    &     dmmeth   = string(1)     &     notdd    = string(
notnot   = string(62)    &     orbcoord = string(10)    &     orbdata1 = string(
grade    = fix(1)        &     orbnot   = string(1)     &     orbref   = string(
notstat  = string(3)     &     orbstat  = string(3)     &     dmstat   = string(
dmcoord  = string(10)    &     name     = string(12)    &     dm2      = string(
numdm    = string(2)     &     dmref    = string(8)     &     dmnote   = string(
notstat  = 'no '         &     orbstat  = 'no '         &     dmstat   = 'no '
n15      = ' '           &     n16      = ' '           &     n17      = ' '
note     = '0'           &     orbit    = '0'           &     deltam   = '0'
spacer   = ' '           &     fakeread = string(10)    &     cgrade   = string(
e0       = string(5)     &     e1       = string(6)     &     e2       = string(
e3       = string(6)     &     e4       = string(5)     &     e5       = string(
e6       = string(5)     &     e7       = string(6)     &     e8       = string(
e9       = string(6)     &     orbinfo  = string(1)     &     notnot2  = string(
n18      = string(2)     &     n19      = string(2)     &     n20      = string(
n21      = string(1)     &     n22      = string(3)     &     n23      = string(
n24      = string(2)     &     n18      = '  '          &     n19      = '  '
n20      = '  '          &     n21      = ' '           &     n22      = '   '
n23      = '  '          &     n24      = '  '          &     notref   = string(
datlin   = string(40)    &     aper     = string(3)     &     meth     = string(
code1    = string(1)     &     code2    = string(1)     &     newref   = string(
n25      = string(4)     &     n26      = string(4)     &     n25      = '    '
n26      = '    '
;
;sample of BIG read
;
;0000000001111111111222222222233333333334444444444555555555566666666667777777777
;123456789.123456789.123456789.123456789.123456789.123456789.123456789.123456789
;09123+1500FIN 347Aa    95999898156301  01  01 72  72 G8V      -526+246+15 2003N
;09123+1500FIN 347Aa    95999887156301  01  01 72  72 G8V      -526+246+15 2003N
;09123+1500       Aa   19840609 1427    0165          1MSN0558S8 5
;09123+1500       Aa    1984.0609 142.7    0.165   .     .    1 Msn1996a158S  5
;<-coord--><-dd--><com><d1><d)12<p><p><s>3<>56<><><><>7<no8><>012<><14><--dm-->5
;
; add summary and measures to .measures file
while (not EOF(2)) do begin
   readf,2,coord,dd,comp,date1,date2,n1,n2,pa1,pa2,sep1,n3,n4,n5,n6,maga1, $
      maga2,magb1,magb2,n7,n8,n9,n10,n11,n12,n13,n14,dm,n15,n16,n17,n18,   $
      n19,n20,n21,n22,n23,n24,n25,n26,datlin,newref,aper,meth,code1,code2, $
      format='(a10,a7,a5,i4,i3,a1,a1,a3,a3,a3,a1,a2,a1,a1,a2,a2,a2,a2,a1,a5,a2,a
   if (dd ne '       ') then begin
      if (n15 eq 'N') then note = '1'
      if (n16 eq 'O') then orbit = '1'
      if (n16 eq 'M') then orbit = '1'
      if (n17 eq 'D') then deltam = '1'
      notstat = 'no '
      orbstat = 'no '
      dmstat = 'no '
      if (n15 eq 'N') then notstat = 'yes'
      if (n16 eq 'O') then orbstat = 'yes'
      if (n16 eq 'M') then orbstat = 'yes'
      if (n17 eq 'D') then dmstat = 'yes'
      if (date1 lt 50) then date1 = date1+2000
      if (date1 le 999) then date1 = date1+1000
      if (date2 lt 50) then date2 = date2+2000
      if (date2 le 999) then date2 = date2+1000
      spacer =' '
      if (n1 eq '9') and (n2 eq '9') then spacer ='>'
      printf,3,' '
      printf,3,' '
      printf,3,' RA & DEC  Disc.   Comp   No.  Magnitudes   Spec.    PM/1000 yr
      printf,3,'  (2000)   Number         Obs.   A     B    Type      RA   DEC'
      printf,3,coord,dd,comp,spacer,n1,n2,maga1,maga2,magb1,magb2,n7,n8,n9,n11,n
         format='(a10,1x,a7,1x,a5,2x,a1,a1,a1,2x,a2,".",a2,1x,a2,".",a2,2x,a1,a5
      printf,3,' '
      if (n18 ne '  ') then printf,3,'Precise Position of Primary of System or S
      if (n18 ne '  ') then printf,3,n18,n19,n20,n21,n22,n23,n24, $
         format='("       RA = ",a2," ",a2," ",a2,".",a1,"       Dec = ",a3," ",
      if (n18 ne '  ') then printf,3,' '
      if (n25 ne '   ') then printf,3,'Proper Motion (PM/1000 yr) of Secondary o
      if (n25 ne '   ') then printf,3,n25,n26, $
         format='("       RA = ",a4,"             Dec = ",a4," ")'
      if (n25 ne '   ') then printf,3,' '
      printf,3,notstat,orbstat,dmstat,format='("Note? = ",a3,3x,"Orbit? = ",a3,3
      printf,3,' '
      printf,3,'          Date Observed     Position Angle     Separation'
      printf,3,date1,pa1,sep1,n3,format='("First",9x,i4,t15,"1",19x,a3,12x,a3,".
      printf,3,date2,pa2,n4,n5,n6,format='("Last",10x,i4,16x,a3,12x,a2,a1,".",a1
      printf,3,' '
      printf,3,'Observations'
      printf,3,'============'
      printf,3,'Date       P.A.     Sep. Mag-a Mag-b  #    RefCode  Aperture  Me
      endif else begin
       printf,3,datlin,newref,aper,meth,code1,code2,format='(a40,3x,a8,3x,a3,8x,
         for i = 0,iref do begin
            if (newref eq refcode2[i]) then refflag[i] = '1'
            endfor
      endelse
   endwhile
; add notes to .measures
if (note eq '1') then begin
   printf,3,' '
   printf,3,'WDS Index Catalog Notes'
   printf,3,'======================='
   openr,5,path+'/wds/wdsnot.memo'
   while (not EOF(5)) do begin
      readf,5,notcoord,notdd,notnot,format='(a10,a7,1x,a62)'
      if (notcoord eq coord) then begin
         printf,3,notnot,format='(a62)'
NEXTREAD:
         readf,5,notcoord,notdd,notnot,format='(a10,a7,1x,a62)'
         if (notcoord ne coord) and (notcoord ne '          ') then goto, OUT
            printf,3,notnot,format='(a62)'
            goto, NEXTREAD
         endif
      endwhile
OUT:
      close,5
   endif
; add orbits to .measures
if (orbit eq '1') then begin
   printf,3,' '
   printf,3,'6th Orbit Catalog Orbits'
   printf,3,'========================'
   openr,6,path+'/wds/orb6.master'
   readf,6,fakeread,format='(a10)'
   readf,6,fakeread,format='(a10)'
   readf,6,fakeread,format='(a10)'
   readf,6,fakeread,format='(a10)'
   while (not EOF(6)) do begin
      readf,6,orbcoord,orbdata1,cgrade,orbinfo,orbnot,orbref,format='(19x,a10,51
      if (orbcoord eq coord) and (orbnot eq 'y') then begin
         printf,3,'     P        a          i      Node        T       e      om
ORBREAD1:
         grade = fix(cgrade)
         printf,3,orbdata1,grade,orbref,format='(a67,i1,1x,a8)'
         for i = 0,iref do begin
            if (orbref eq refcode2[i]) then refflag[i] = '1'
            endfor
ORBREAD2:
         readf,6,orbcoord,orbdata1,cgrade,orbinfo,orbnot,orbref,format='(19x,a10
         if (orbcoord eq coord) and (orbnot eq 'y') then goto, ORBREAD1
         if (orbcoord eq coord) and (orbnot eq 'n') then goto, ORBREAD2
         if (orbcoord eq '          ') and (orbnot eq ' ') then goto, ORBREAD2
         endif
      endwhile
      close,6
   endif
; add ephemerides to file
if (orbit eq '1') then begin
   printf,3,' '
   printf,3,'6th Orbit Catalog Ephemerides'
   printf,3,'-----------------------------'
   openr,8,path+'/wds/orb6.ephem'
   readf,8,fakeread,format='(a10)'
   readf,8,fakeread,format='(a10)'
   readf,8,fakeread,format='(a10)'
   readf,8,fakeread,format='(a10)'
   while (not EOF(8)) do begin
      readf,8,orbcoord,orbref,e0,e1,e2,e3,e4,e5,e6,e7,e8,e9, $
         format='(a10,15x,a8,4x,a5,1x,a6,3x,a5,1x,a6,3x,a5,1x,a6,3x,a5,1x,a6,3x,
      if (orbcoord eq coord) then begin
         printf,3,'Refcode   Theta  Rho    Theta  Rho    Theta  Rho    Theta  Rh
         printf,3,'              2004          2005          2006          2007
FEMREAD:
         printf,3,orbref,e0,e1,e2,e3,e4,e5,e6,e7,e8,e9, $
            format='(a8,2x,a5,1x,a6,2x,a5,1x,a6,2x,a5,1x,a6,2x,a5,1x,a6,2x,a5,1x
         readf,8,orbcoord,orbref,e0,e1,e2,e3,e4,e5,e6,e7,e8,e9, $
            format='(a10,13x,a8,4x,a5,1x,a6,3x,a5,1x,a6,3x,a5,1x,a6,3x,a5,1x,a6,
         if (orbcoord eq coord) then goto, FEMREAD
         endif
      endwhile
      close,8
   endif
; add orbit catalog notes to file
if (orbit eq '1') then begin
   openr,6,path+'/wds/orb6.master'
   readf,6,fakeread,format='(a10)'
   readf,6,fakeread,format='(a10)'
   readf,6,fakeread,format='(a10)'
   readf,6,fakeread,format='(a10)'
   while (not EOF(6)) do begin
      readf,6,orbcoord,orbdata1,cgrade,orbnot,orbinfo,orbref,format='(19x,a10,51
      if (orbcoord eq coord) and (orbinfo eq 'n') then begin
         openr,9,path+'/wds/orb6.notes'
         readf,9,fakeread,format='(a10)'
         readf,9,fakeread,format='(a10)'
         while (not EOF(9)) do begin
            readf,9,notcoord,notnot2,notref,format='(a10,10x,a70,a8)'
            if (notcoord eq coord) then begin
               printf,3,' '
               printf,3,'6th Orbit Catalog Notes'
               printf,3,'-----------------------'
               printf,3,notnot2,format='(a70)'
NEXTREAD2:
               readf,9,notcoord,notnot2,notref,format='(a10,10x,a70,a8)'
               if (notcoord ne coord) and (notcoord ne '          ') then goto,
               printf,3,notnot2,format='(a70)'
               if (notref eq '        ') then goto, NEXTREAD2
                  for i = 0,iref do begin
                     if (notref eq refcode2[i]) then refflag[i] = '1'
                     endfor
               goto, NEXTREAD2
              endif
           endwhile
         endif
         close,9
      endwhile
OUT2:
   close,6
   endif
; add delta-m to .measures
if (deltam eq '1') then begin
   printf,3,' '
   printf,3,'Delta-M Catalog Measures'
   printf,3,'========================'
   openr,7,path+'/wds/deltam.txt'
   while (not EOF(7)) do begin
      readf,7,dmcoord,name,dm2,numdm,dmref,dmmeth,dmnote,format='(a10,1x,a12,a5,
      if (dmcoord eq coord) then begin
      if (numdm eq '  ') then numdm = ' ?'
         printf,3,'Name & Comp     DM    Method   N    Notes (e.g. filter, error
DMREAD:
         if (numdm eq '  ') then numdm = ' ?'
         printf,3,name,dm2,dmmeth,numdm,dmnote,dmref,format='(a12,3x,a5,4x,a1,6x
         for i = 0,iref do begin
            if (dmref eq refcode2[i]) then refflag[i] = '1'
            endfor
         readf,7,dmcoord,name,dm2,numdm,dmref,dmmeth,dmnote,format='(a10,1x,a12,
         if (dmcoord eq coord) then goto, DMREAD
         endif
      endwhile
      close,7
   endif
; add references to .measures
printf,3,' '
printf,3,'WDS References'
printf,3,'reference code       Author(s)/Reference'
printf,3,'========================================'
for i=0,iref do begin
   if (refflag[i] eq '1') then printf,3,refcode2[i],ref1[i],ref2[i], $
      format='(a8,13x,a37,/,21x,a60)'
   endfor
   close,2
   close,3
   return
   end
