pro deadcorr,remove=remove,dt=dt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Apply/remove dead time [s] corrections to visibility data.
; Only works with one baseline per detector.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if system_id(systemid) ne 'NPOI' $
or produkt(genconfig.numbaseline[0:genconfig.numoutbeam-1]) ne 1 then return
;
if n_elements(remove) eq 0 then remove=0
if n_elements(dt) eq 0 then dt=200e-9
;
vissq=reform(scans.vissq)
vissqe=reform(scans.vissqe)
vissqc=reform(scans.vissqc)
vissqerr=reform(scans.vissqcerr)
index=where(vissqerr lt 0,count)
if count gt 0 then begin
	vissq[index]=0
	vissqe[index]=0
	vissqc[index]=0
endif
;
faktor=((1+dt*abs(scans.photonrate)*500*(1-vissq^2)))^2
if remove then faktor=1/faktor
scans[*].vissq(*,*)=vissq*faktor
scans[*].vissqe(*,*)=vissqe*faktor
scans[*].vissqc(*,*)=vissqc*faktor
;
for i=0,genconfig.numtriple-1 do begin
	f1=1+dt*abs(scans[*].photonrate(0,*))*500*(1-vissq[0,*,*]^2)
	f2=1+dt*abs(scans[*].photonrate(1,*))*500*(1-vissq[1,*,*]^2)
	f3=1+dt*abs(scans[*].photonrate(2,*))*500*(1-vissq[2,*,*]^2)
	faktor=f1*f2*f3
	if remove then faktor=1/faktor
	scans.tripleamp=scans.tripleamp*faktor
	scans.tripleampe=scans.tripleampe*faktor
	scans.tripleampc=scans.tripleampc*faktor
endfor
;
if remove then print,'Dead time corrections removed.' $
	  else print,'Dead time corrections applied.'
;
end
