pro defaultbg
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initializes background table and scans so that one can average pointdata
; if no measured values are available. Default back ground rate is zero.
;
common StarBase,startable,notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,ScanTable,BGTable,StationTable
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if checkdata([1,3,8]) ne 0 then return
numscan=n_elements(ScanTable)
;
Iscan=lindgen(numscan)+1
ScanId=lonarr(numscan) & ScanId[*]=ScanTable.ScanId
Time=dblarr(numscan) & Time[*]=ScanTable.StopTime
StarId=strarr(numscan) & StarId[*]=ScanTable.StarId
Ra=dblarr(numscan,/nozero)
Dec=dblarr(numscan,/nozero)
for i=0,n_elements(startable)-1 do begin
	index=where(StarId eq startable[i].starid,count)
	if count then begin
		Ra[index]=startable[i].Ra
		Dec[index]=startable[i].Dec
	endif
endfor
BGTable=build_bgtable(Iscan,ScanId,Time,Ra,Dec)
print,'Default Backgroundtable created.'
;
MS=max(GenConfig.NumSpecChan)
s=allocbgscan(GenConfig.NumOutBeam,MS)
bgscans=replicate(s,numscan)
bgscans.Time=BGTable.Time
bgscans.Rate=0
bgscans.RateErr=1
;
print,'Default Background data set.'
;
end
