function dewpoint,temp_c,rh_in
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute dew point from (dry bulb) air temperature [C] and rel. humidity [%],
; according to Magnus approximation. (https://en.wikipedia.org/wiki/Dew_point)
;
; temp_c=temp_k-273.15
;
rh=rh_in
index=where(rh eq 0,count)
if count ne 0 then rh[index]=1
;
a=6.1121	; [mb]
b=18.678
c=257.14	; degrees Celsius
d=234.5		; degrees Celsius
g=alog(rh/100.)+(b*temp_c)/(c+temp_c)
return,(c*g)/(b-g)
;
end
