pro dewraptriple
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Unwrap the (calibrated) triple phase by subtracting a fit vs. wavelength
; derived from a stretch of phases without wraps. This fit is currently
; done manually using the Util|FIT plot utility!
;
; Only the triple phase of the selected calibrator stars is unwrapped!
;
common FitPlotData,x_mid,x_scl,s
common SolInfo,cal_stars,cal_options,indicators,sel_indct,sel_funcn
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
RAD=180/pi_circle
;
if n_elements(cal_stars) eq 0 then begin
	print,'***Error(DEWRAPTRIPLE): no calibrator stars defined!'
	return
endif
if cal_stars[0] eq '' then begin
	print,'***Error(DEWRAPTRIPLE): no calibrator stars selected!'
	return
endif
;
; Obtain scan index corresponding to calibrator selection
list_stars,stars
mask=intarr(n_elements(scans))
for k=0,n_elements(stars)-1 do begin
	index=where(cal_stars eq stars[k],count)
	if count eq 0 then begin
		index=where(scans.StarId eq stars[k])
		mask[index]=-1
	endif
endfor
calscan_index=where(mask eq 0,calscan_count)
;
; Comment next two lines if you don't want all stars selected
; calscan_index=indgen(n_elements(scans))
; calscan_count=n_elements(scans)
;
numchan=n_elements(scans[0].triplephase(0,*))
;
; y_fit=poly(findgen(numchan)+1,s)/RAD
y_fit=polynom(findgen(numchan)+1,[s,x_mid,x_scl])/RAD
;
for i=0,calscan_count-1 do begin
	scans[calscan_index[i]].triplephasec(0,*)= $
       (scans[calscan_index[i]].triplephasec(0,*)-y_fit) mod (2*pi_circle)
	index=where(scans[calscan_index[i]].triplephasec lt -pi_circle,count)
	if count gt 0 then scans[calscan_index[i]].triplephasec(0,index)= $
			   scans[calscan_index[i]].triplephasec(0,index)+2*pi_circle
	index=where(scans[calscan_index[i]].triplephasec gt +pi_circle,count)
	if count gt 0 then scans[calscan_index[i]].triplephasec(0,index)= $
			   scans[calscan_index[i]].triplephasec(0,index)-2*pi_circle
	scans[calscan_index[i]].triplephasec= $
	scans[calscan_index[i]].triplephasec+y_fit
endfor
;
if not !quiet then print,'Unwrapping completed.'
;
end
