function dft,image,c,u,v,ch,db=db
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Given a map and complex visibilities at coordinates (u,v), add to the map
; the direct Fourier transform of the visibilities evaluated at the map
; coordinates. Zero the map before if needed.
;
; Index ch specifies which plane of the map cube to compute.
;
if n_elements(ch) eq 0 then ch=0
if n_elements(db) eq 0 then db=0
;
img=image
map=img.maps[ch].map
r=size(map)
;
ur=-2*!pi*u
vr=-2*!pi*v
;
cr=float(c)/n_elements(c)
ci=imaginary(c)/n_elements(c)
;
if db then begin
;
	dbxsize=r[1]
	dbysize=r[2]
;
	k=dbysize/2+1
	l=k*dbxsize-1
;
	m2=map[*,0:k-1]
	x=image.x[0:l]
	y=image.y[0:l]
;	for i=0L,n_elements(c)-1 do begin
;		p=ur(i)*x+vr(i)*y
;		m2=m2+cr(i)*cos(p)
;	endfor
	m2=m2+reform(cr#cos(ur#x+vr#y),size(m2,/dim))
;
	map[*,0:k-1]=m2
	map[*,k:dbysize-1]=reverse(reverse(map[*,0:k-2],2),1)
	img.maps[ch].map=map
;
endif else begin
;
	for i=0L,n_elements(c)-1 do begin
        	p=ur[i]*image.x+vr[i]*image.y
        	map=map+(cr[i]*cos(p)-ci[i]*sin(p))
	endfor
	img.maps[ch].map=map
;
endelse
;
return,img
;
end
