function diam_brightgiant,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate diameters of bright giants based on type, obtained from an
; experimental calibration using the surface brightness method on the
; Sky Catalog data. Uncertainty of estimates 25%.
;
; Unit is the radius of the Sun
;
common StarBase,StarTable,Notes
;
type=float(type)
;
if 0 then begin		; Run only to compute coefficients
	get_sky
	i=where(startable.class eq 2)
	startable=startable[i]
	get_jhk
	i=where(startable.mk ne 100)
	startable=startable[i]
	diameter_vk
	sv=startable.mv+5.*alog10(startable.diameter)
	plot,startable.type,sv,psym=1
	n=60
	t=findgen(n)+12
	v=t*0
	for i=0,n-1 do begin
		j=where(startable.type eq t[i],count)
		if count ge 2 then v[i]=median(sv[j])
	endfor
	index=where(v ne 0)
	v=v[index]
	t=t[index]
	r=poly_fit(t,v,2,vfit)
	x=findgen(70)
	oplot,x,poly(x,r),psym=0,color=tci(2)
endif
r=[3.42353,-0.0252380,0.00177207]
sv=poly(type,r)
return,10^(0.2*(sv-amv_brightgiant[type]))
;
end
