function diam_dwarf,type
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Estimate stellar diameter from bolometric magnitude and effective temperature.
; Unit is the radius of the Sun
;
; Input type as used by OYSTER: O0:00, B0:10, A0:20, F0:30, G0:40, K0:50, M0:60
;
type=float(type)
;
d_type=''       ; Spectral type
d_ft=0.         ; Floating spectral type
d_t=0.          ; log(T_eff/K)
d_c=0.          ; Color (U-B, B-V, etc.)
d_mv=0.         ; M_V
d_mb=0.         ; M_bol
status=dc_read_free(!oyster_dir+'starbase/spec_par.V', $
        d_type,d_ft,d_t,d_c,d_mv,d_mb, $
        /col,resize=[1,2,3,4,5],ignore=['!'])
;
si=sort(type)
teff=fltarr(n_elements(type))
mbol=fltarr(n_elements(type))
teff[si]=10^spline(d_ft,d_t,type[si])
mbol[si]=spline(d_ft,d_mb,type[si])
;
logl=(4.74-mbol)/2.5	; Allen's Astrophysical Quantities, p.382, 15.1.1
diam=10^((logl-4*(alog10(teff)-3.762))/2)*2
;
return,diam
;
end
