function diam_star,spectrum
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Stellar diameter in units of the solar radius (R_Sun)
;
n=n_elements(spectrum)
if n eq 0 then return,-1
diam=fltarr(n)
spec_parse,spectrum,type,class,type2,class2
;
; Dwarfs
index=dwarfs(class,type,1)
if index[0] ne -1 then diam[index]=diam_dwarf(type[index])
;
; Giants
index=giants(class,type,1)
if index[0] ne -1 then diam[index]=diam_giant(type[index])
;
; Sub-giants
index=subgiants(class,type)
if index[0] ne -1 then diam[index]=diam_subgiant(type[index])
;
; Super giants
index=supergiants(class,type,1)
if index[0] ne -1 then diam[index]=diam_supergiant(type[index])
;
if n eq 1 then diam=diam[0]
return,diam
;
end
