pro diameter_bv,force=force
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute apparent diameter of star in mas from (B-V) color index and m_V.
; Do this only for single stars earlier than M and dwarf through giant.
; Note: probably not very accurate, and not tested well.
;
common StarBase,StarTable,Notes
;
if n_elements(force) eq 0 then force=0
;
r=[0.496,0.975,-0.661,0.269]
;
startable.diameter=0
index=where(StarTable.bv lt 1.6 $
	and StarTable.mv ne +100 $
	and StarTable.bflag ne 'B' $
	and StarTable.class ge 3 $
	and StarTable.type lt 70,count)
if force then $
index=where(StarTable.bv ne +100 $
	and StarTable.mv ne +100,count)
if count gt 0 then begin
	logud=poly(StarTable[index].bv,r)
	StarTable[index].diameter=10^(logud-0.2*StarTable[index].mv)
endif
;
end
