pro diameter_ri,force=force
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute apparent UD diameter of star at 800 nm in mas from (R-I) color index
; and m_V. Do this only for non-supergiants.
;
common StarBase,StarTable,Notes
;
if n_elements(force) eq 0 then force=0
;
; Old polynomial coefficients
; r=[0.518,1.299,-0.308]
;
; New coefficients with Dave's Mark III diameter data
r=[0.50017342,1.5095543,-0.62435937,0.13392176]
;
startable.diameter=0
index=where(StarTable.ri ne +100 $
	and StarTable.mv ne +100 $
	and StarTable.bflag ne 'B' $
	and StarTable.class ge 2,count)
if force then $
index=where(StarTable.ri ne +100 $
	and StarTable.mv ne +100,count)
if count gt 0 then begin
	logud=poly(StarTable[index].ri,r)
	StarTable[index].diameter=10^(logud-0.2*StarTable[index].mv)
endif
;
end
