pro diameter_vk,mv,mk,d_vk,force=force
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute apparent LD diameter of star in mas from (V-K) color index and m_V.
; Use coefficients fit to data from van Belle et al. 2009 for supergiants
; and brightgiants (ptisgbg.pro), unless forced. "Surface-brightness method"
;
; Nov 3, 2015: added computation of secondary diameter, diameter2.
; Jan 31, 2018: added parameters mv,mk for on-the-spot computations (MS only)
;
common StarBase,StarTable,Notes
;
; New coefficients with Dave's Mark III diameter data
r=[2.658,1.385,-0.021]
;
; Option to print or return estimated diameters
if n_params() ge 2 then begin
	vk=mv-mk
	logud=poly(vk,r)
	d_vk=10^(0.2*(logud-mv))
	if n_params() eq 2 then print,d_vk
	return
endif
;
if n_elements(force) eq 0 then force=0
;
startable.diameter=0
index=where(StarTable.mv ne +100 $
	and StarTable.mk ne +100 $
	and StarTable.bflag ne 'B' $
	and StarTable.class ge 3,count)
if force then $
index=where(StarTable.mv ne +100 $
	and StarTable.mk ne +100,count)
if count gt 0 then begin
	vk=startable[index].mv-startable[index].mk
	logud=poly(vk,r)
;	Also estimate diameters of secondaries
	mv12=dmag(StarTable[index].mv,StarTable[index].dmv)
	j=where(StarTable[index].dmv eq 100,nj)
	StarTable[index].diameter=10^(0.2*(logud-mv12[0,*]))
	StarTable[index].diameter2=10^(0.2*(logud-mv12[1,*]))
	if nj gt 0 then StarTable[index[j]].diameter2=0
endif
if force then return
;
; Using coefficients fit to data in van Belle et al. 2009 for brightgiants
r=[2.869,1.292,-0.018]
index=where(StarTable.mv ne +100 $
	and StarTable.mk ne +100 $
	and StarTable.bflag ne 'B' $
	and StarTable.class eq 2,count)
if count gt 0 then begin
	vk=startable[index].mv-startable[index].mk
	logud=poly(vk,r)
	StarTable[index].diameter=10^(0.2*(logud-StarTable[index].mv))
endif
;
; Using coefficients fit to data in van Belle et al. 2009 for supergiants
r=[2.633,1.407,-0.032]
index=where(StarTable.mv ne +100 $
	and StarTable.mk ne +100 $
	and StarTable.bflag ne 'B' $
	and StarTable.class lt 2,count)
if count gt 0 then begin
	vk=startable[index].mv-startable[index].mk
	logud=poly(vk,r)
	StarTable[index].diameter=10^(0.2*(logud-StarTable[index].mv))
endif
;
end
