pro diffmap,ch
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Compute differential map, DM (same as DM if no model is available).
; Set RM to equal DM.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
;
if n_elements(ch) eq 0 then ch=0
;
uci=unique(ci)
if ch ge 1 then index=where(ci eq uci[ch-1]) $
	   else index=lindgen(n_elements(ci))
;
dm.maps[ch].map=0
dm=dft(dm,cv[index]-mv[index],uc[index],vc[index],ch)
status=set_scale(dm,ch)
rm.maps[ch].map=dm.maps[ch].map
r=set_scale(rm,ch)
;
print,'Residual map rms: ' $
	+string(stddev(dm.maps[ch].map)*100,format='(f5.1)')+' %'
;
end
