function dirtybeam,star
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Return the synthesized beam for a given star and observation.
;
common BeamInfo,reduce
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common Tables,scantable,bgtable,stationtable
;
if n_elements(star) eq 0 then begin
	print,'***Error(DIRTYBEAM): no star specified!'
	return,-1
endif
;
imsize=512
;
for night=0,n_elements(bufferinfo)-1 > 0 do begin
if n_elements(bufferinfo) gt 1 then $
loadnight,GenInfo[night[0]].date, $
          GeoInfo[night[0]].systemid, $
          GenInfo[night[0]].configid
index=where(scans.starid eq star and scantable.code eq 1,count)
if night eq 0 then reduce=2e6*max(abs(scans[index].uvw))/70e6 $
	      else reduce=max([2e6*max(abs(scans[index].uvw))/70e6,reduce])
endfor
map=fltarr(imsize,imsize)
;
FOR night=0,n_elements(bufferinfo)-1 > 0 DO BEGIN
;
if n_elements(bufferinfo) gt 1 then $
loadnight,GenInfo[night[0]].date, $
          GeoInfo[night[0]].systemid, $
          GenInfo[night[0]].configid
;
index=where(scans.starid eq star and scantable.code eq 1,count)
if count eq 0 then begin
	print,'***Error(DIRTYBEAM): no scans on this star for this date!'
	return,-1
endif
;
e=reform(scans[index].vissqcerr,n_elements(scans[index].vissqerr))
v=reform(scans[index].uvw(*,*,*,1),n_elements(scans[index].uvw(*,*,*,1)))
u=reform(scans[index].uvw(*,*,*,0),n_elements(scans[index].uvw(*,*,*,0)))
; If you want to compare the beam to the one in AIPS, flip the sign of u
u=-u
;
; Edit the uv-coverage
index=where(e gt 0,count)
if count eq 0 then begin
	print,'***Error(DIRTYBEAM): no data for this star!'
	return,-1
endif
u=u[index] & v=v[index]
;
; Place the data on a regular grid and add coordinates symmetric to origin
index=where(u lt 0,count) & if count gt 0 then u[index]=u[index]-reduce/2
index=where(u gt 0,count) & if count gt 0 then u[index]=u[index]+reduce/2
index=where(v lt 0,count) & if count gt 0 then v[index]=v[index]-reduce/2
index=where(v gt 0,count) & if count gt 0 then v[index]=v[index]+reduce/2
u=fix(u/reduce) & u=[u,-u]
v=fix(v/reduce) & v=[v,-v]
;
; Flip negative spatial frequencies
index=where(u lt 0,count) & if count gt 0 then u[index]=imsize+u[index]
index=where(v lt 0,count) & if count gt 0 then v[index]=imsize+v[index]
;
; Copy the grid into the map
map[u,v]=1
;
endfor
;
; Compute and return the beam
return,shift(float(fft(map,1)),imsize/2,imsize/2)
;
end
