pro dispcorr,cl=cl,wt=wt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; New version!
;
; Calculate dispersion corrections to station delays. Input data are unwrapped
; visibility phases from a coherent integration. All baselines are used to
; derive station based solutions of vacuum delay and atmospheric parameters.
;
; The phase is written as: phi/2pi = c + s*d0 + s*A(s)*d1 + s*B(s)*d2,
; where s=1/lambda, c is a baseline dependent phase offset to handle unequal
; beam combiner paths, d0 is the vacuum delay, d1 is the dry air path, and d2
; is the wet air path.
;
; Solutions for c should be multi-modal, i.e. they should have a spacing
; of unity. This is enforced in a second iteration.
;
; This procedure enforces a zero closure group delay. This is done either
; by looking only at the reference baseline results (cl=0) or by adding
; mulitple paths with the proper closure phase offsets included.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if checkdata([8,11]) ne 0 then return
;
if n_elements(cl) eq 0 then cl=0 else cl=cl gt 0
if n_elements(wt) eq 0 then wt=0 else wt=wt gt 0
;
; Set up the design matrix
nsd=GenConfig.NumSid
;
; Initialize data
numpoint=n_elements(VisPhase[0,0,0,*])
GrpDelay=fltarr(nsd,numpoint)
DryDelay=fltarr(nsd,numpoint)
WetDelay=fltarr(nsd,numpoint)
GrpDelayErr=fltarr(nsd,numpoint)-1
DryDelayErr=fltarr(nsd,numpoint)-1
WetDelayErr=fltarr(nsd,numpoint)-1
;
; Baseline-based calibrated delays
grpdelays=fltarr(genconfig.numoutbeam, $
		 max(genconfig.numbaseline[0:genconfig.numoutbeam-1]), $
		 numpoint)
drydelays=fltarr(genconfig.numoutbeam, $
		 max(genconfig.numbaseline[0:genconfig.numoutbeam-1]), $
		 numpoint)
;
; Reference station
refstation=genconfig.stationid[genconfig.refstation-1]
;
; Integer fringe ID solutions
fidsol=fltarr(n_elements(StarID))
;
; Prepare plot window
if !d.name ne 'PS' then begin
	window,/free
	set_screen
endif
!p.multi=[0,genconfig.numoutbeam,max(genconfig.numbaseline)]
!p.charsize=2.0
;
data_check=0
;
for i=0,GenConfig.NumOutBeam-1 do begin
for l=0,GenConfig.NumBaseline[i]-1 do begin
;
;	Find out if baseline with reference
	baselineid=genconfig.baselineid[l,i]
	pos=strpos(baselineid,refstation)
	sid=-1
	if pos eq 0 then $
	sid=where(genconfig.stationid eq strmid(baselineid,4,3)) $
		    else if pos gt 0 then $
	sid=where(genconfig.stationid eq strmid(baselineid,0,3))
	sid=sid[0]
;
;	Find out which channels are flagged
	pe=VisPhaseErr[i,*,l,*]
	index=where(pe le 0,count)
	if count gt 0 then pe[index]=0
	chi=where(total(abs(pe),4) ne 0,nch)
;
if nch gt 0 then begin
	data_check=1
;	Initialize coefficients
	s=1.d0/(GenConfig.Wavelength[chi,i]*1.d6)
	a=a_disp[0]+a_disp[1]/(a_disp[2]-s^2)+a_disp[3]/(a_disp[4]-s^2)
	a=a/10000.d0	; We want coefficients of similar magnitude
	b=b_disp[0]+b_disp[1]*s^2
;
;	Group delays (do not use weights)
	y=reform(VisPhase[i,chi,l,*]/(2*!pi))
	m=dblarr(nch,2)
	m[*,0]=s
	m[*,1]=1
	tm=transpose(m)
	n=tm#m
	r=tm#y
	v=invert(n)#r
	grpdelays[i,l,*]=v[0,*]-SoftDelay[i,l,*]*1e6
	if sid ge 0 then grpdelayerr[sid,*]=1
;
;	Dry air solution, weighted for fringe ID solution
	fidsol=fltarr(n_elements(StarId))
	for k=0,n_elements(StarId)-1 do begin
;		Initialize data
		e=reform(VisPhaseErr[i,chi,l,rec0[k]:recn[k]])/(2*!pi)
		w=e & for j=0,nch-1 do w[j,*]=1.0/median(e[j,*])
		if wt eq 0 then w[*]=1
		y=reform(VisPhase[i,chi,l,rec0[k]:recn[k]]/(2*!pi))*w
		w=reform(w[*,0])
		m=dblarr(nch,3)
		m[*,0]=s*w
		m[*,1]=s*a*w
		m[*,2]=w
		tm=transpose(m)
		n=tm#m
		r=tm#y
		v=invert(n)#r
		fidsol[k]=medianve(v[2,*])
	endfor
;
;	Plot fringe ID results
	indexs=where(starid ne 'FKV0000',counts)
	if counts gt 0 then $
	plot,indexs,fidsol[indexs],psym=1, $
		title='OB '+string(i+1)+', BL '+string(l+1), $
		xtitle='Scan ID',ytitle='Fringe ID'
	indexw=where(starid eq 'FKV0000',countw)
	if countw gt 0 and counts gt 0 then $
	oplot,indexw,fidsol[indexw],psym=1,color=tci(2)
        if counts eq 0 and countw gt 0 then $
        plot,indexw,fidsol[indexw],psym=1, $
                title='OB '+string(i+1)+', BL '+string(l+1)
;
;	Enforce integer fringe ID solution
	if counts eq 0 then indexs=lindgen(countw)
;	Set pt=0 since different scans can have different fringe IDs
	fidsol[indexs]=fringeid(fidsol[indexs],pt=0)
;
;	Compute final dry air delay solution
	for k=0,n_elements(StarId)-1 do begin
;		Initialize data
		e=reform(VisPhaseErr[i,chi,l,rec0[k]:recn[k]])/(2*!pi)
		w=e & for j=0,nch-1 do w[j,*]=1.0/median(e[j,*])
		if wt eq 0 then w[*]=1
		y=[reform(VisPhase[i,chi,l,rec0[k]:recn[k]]/(2*!pi))*w, $
		   fltarr(1,recn[k]-rec0[k]+1)]
		y[nch,*]=fidsol[k]*avg(w)
		w=reform(w[*,0])
		m=dblarr(nch+1,3)
		m[0:nch-1,0]=s*w
		m[0:nch-1,1]=s*a*w
		m[0:nch-1,2]=w
		m[nch,2]=avg(w)
		tm=transpose(m)
		n=tm#m
		r=tm#y
		in=invert(n)
		v=in#r
		oplot,v[2,*]*0+k,v[2,*],psym=3,color=tci(3)
		drydelays[i,l,rec0[k]:recn[k]]=v[0,*]-SoftDelay[i,l,rec0[k]:recn[k]]*1e6
		if sid ge 0 then drydelayerr[sid,rec0[k]:recn[k]]=sqrt(in[0,0])
	endfor
endif
;
endfor
endfor
;
if not data_check then begin
	print,'Error(DISPCORR): no valid data found!'
	return
endif
;
grpdelayerr[GenConfig.RefStation-1,*]=1
drydelayerr[GenConfig.RefStation-1,*]=1
;
; Transfer baseline solutions to stations
for i=0,GenConfig.NumOutBeam-1 do begin
for l=0,GenConfig.NumBaseline[i]-1 do begin
;
baselineid=genconfig.baselineid[l,i]
pos=strpos(baselineid,refstation)
if pos ge 0 and total(signof(grpdelayerr[i,l,*])) gt -numpoint then begin
;
; Basic solution from baseline involving reference station
if pos eq 0 then begin
	k=where(genconfig.stationid eq strmid(baselineid,4,3))
	k=k[0]
	sign=-1
endif else begin
	k=where(genconfig.stationid eq strmid(baselineid,0,3))
	k=k[0]
	sign=+1
endelse
grpdelay[k,*]=grpdelays[i,l,*]*sign
drydelay[k,*]=drydelays[i,l,*]*sign
;
; Exploit closure relation
if cl then begin
for j=0,genconfig.numtriple-1 do begin
	m0=-1
	for m=0,2 do if genconfig.triplebeam[m,j] eq i $
	    	    and genconfig.triplebase[m,j] eq l then m0=m
	if m0 ge 0 then begin
		pe1=VisPhaseErr[genconfig.triplebeam[0,j],*, $
			        genconfig.triplebase[0,j],*]
		pe2=VisPhaseErr[genconfig.triplebeam[1,j],*, $
			        genconfig.triplebase[1,j],*]
		pe3=VisPhaseErr[genconfig.triplebeam[2,j],*, $
			        genconfig.triplebase[2,j],*]
		index=where(pe1 le 0,count)
		if count gt 0 then pe1[index]=0
		index=where(pe2 le 0,count)
		if count gt 0 then pe2[index]=0
		index=where(pe3 le 0,count)
		if count gt 0 then pe3[index]=0
		chi=where(total(abs(pe1),4) ne 0 $
      		      and total(abs(pe2),4) ne 0 $
      		      and total(abs(pe3),4) ne 0,nch)
		cde=fltarr(n_elements(rec0))
		cdt=fltarr(n_elements(rec0))
		msk=fltarr(numpoint)+1
		for n=0,n_elements(rec0)-1 do begin
			p=fltarr(nch)
			for jj=0,nch-1 do $
			p[jj]=cphase(complex( $
				avg(compltriple[j,0,chi[jj],rec0[n]:recn[n]]), $
				avg(compltriple[j,1,chi[jj],rec0[n]:recn[n]])))
			p=phaseunwrap(p)*180/!pi
			x=genconfig.wavelength[chi,i]*1e6
			dm=dblarr(nch,3)
			dm[*,0]=evalfunction('P_0',x)
			dm[*,1]=evalfunction('P_1',x)
			dm[*,2]=evalfunction('P_2',x)
			tm=transpose(dm)
			nm=tm#dm
			r=tm#p
			s=invert(nm)#r
			cde[n]=(s[1]+s[2])/360
			cdt[n]=avg(pointtime[rec0[n]:recn[n]])/3600
			if StarId[n] eq 'FKV0000' then msk[rec0[n]:recn[n]]=0
		endfor
		index=where(StarId ne 'FKV0000')
		cdt=cdt[index]
		cde=cde[index]
		mcde=medianve(cde,mcdee)
		print,'Triple #',j+1,' median value CDE, error [microns]: ', $
			mcde,mcdee
		index=where(abs(cde-mcde) le 3*mcdee)
		cdt=cdt[index]
		cde=cde[index]
		case m0 of
			0:sign=-1
			1:sign=+1
			2:sign=-1
		endcase
		drydelay[k,*]=(drydelay[k,*]+msk*sign*( $
			     -drydelays[genconfig.triplebeam[0,j], $
					genconfig.triplebase[0,j],*]*(m0 ne 0) $
		   	     +drydelays[genconfig.triplebeam[1,j], $
					genconfig.triplebase[1,j],*]*(m0 ne 1) $
		   	     -drydelays[genconfig.triplebeam[2,j], $
					genconfig.triplebase[2,j],*]*(m0 ne 2) $
		   	     +poly(pointtime/3600,poly_fit(cdt,cde,2))))/2
	endif
endfor
endif
;
endif
;
endfor
endfor
;
print,'Finished dispersion correction.'
;
end
