pro dispcorr_old,solutions_out,dw=dw,pt=pt
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Calculate dispersion correction to station delays. Input data are unwrapped
; visibility phases from a coherent integration. All baselines are used to
; derive station based solutions of vacuum delay and atmospheric parameters.
; If solutions_in is defined, the phase wrap solution will be enforced in the
; new solutions.
;
; The phase is written as: phi/2pi = c + s*d0 + s*A(s)*d1 + s*B(s)*d2,
; where s=1/lambda, c is a baseline dependent phase offset to handle closure
; phase offsets, d0 is the vacuum delay, d1 is the dry air delay, and d2 is
; the wet air delay.
;
; The design matrix is set up in the following way:
; c1  c2  c3  d1  d2  d3  a1  a2  a3  b1  b2  b3
; ----------------------------------------------
; 1   0   0   s  -s   0   sa -sa  0   sb -sb  0
; ....for every channel on this baseline
; 0   1   0   s   0  -s   sa  0  -sa  sb  0  -sb
; ....for every channel on this baseline
; 0   0   1   0   s  -s   0   sa -sa  0   sb -sb
; ....for every channel on this baseline
;
; The right hand side is just phi/2pi. This is done for every sample.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common Constants,c_light,pi_circle,e_euler,i_complex,a_disp,b_disp
;
if checkdata([8,11]) ne 0 then return
;
if n_elements(dw) eq 0 then dw=0 else dw=dw gt 0 & dp=1
if n_elements(pt) eq 0 then pt=0 else pt=pt gt 0
;
print,'DispCorr begins...'
;
; Set up the design matrix
nsd=GenConfig.NumSid
nph=long(total(GenConfig.NumBaseline[0:GenConfig.NumOutBeam-1]));
nrow=long(total(GenConfig.Numbaseline[0:GenConfig.NumOutBeam-1] $
               *GenConfig.NumSpecChan[0:GenConfig.NumOutBeam-1]))+3+nph
ncol=nsd*3+nph				; 3 solutions: grp, dry, wet
m=make_array(nrow,ncol,/double,/nozero)	; design matrix
r=make_array(nrow,/double,/nozero)	; right hand side
f=make_array(nrow,/double,/nozero)	; to reconstruct unweighted phases
;
; Initialize data
numpoint=n_elements(VisPhase[0,0,0,*])
GrpDelay=fltarr(nsd,numpoint)
DryDelay=fltarr(nsd,numpoint)
WetDelay=fltarr(nsd,numpoint)
GrpDelayErr=fltarr(nsd,numpoint)-1
DryDelayErr=fltarr(nsd,numpoint)-1
WetDelayErr=fltarr(nsd,numpoint)-1
;
GrpResidual=fltarr(2,numpoint)	; group-delay residuals, mean and STDEV
DryResidual=fltarr(2,numpoint)	; dry-air delay res., mean and STDEV
WetResidual=fltarr(2,numpoint)	; moist-air delay res., mean and STDEV
;
index=where(VisPhaseErr gt 0,n)
if n gt 0 then w_avg=avg(1.d0/(VisPhaseErr[index]/(2*pi_circle))) else return
;	       w_avg=10.d0; This could be more stable
;
solutions_out=dblarr(ncol,numpoint)
ill_condition=intarr(numpoint)
;
computation:
for k=0L,numpoint-1 do begin
	ph=0		; index for phase wrap solutions
	tcount=0
	m[*,*]=0.d0
	r[*]=0.d0
	f[*]=0.d0
	for i=0,GenConfig.NumOutBeam-1 do begin
	  nch=GenConfig.NumSpecChan[i]
	  nbl=GenConfig.NumBaseline[i]
	  s=1.d0/(GenConfig.Wavelength[0:nch-1,i]*1.d6)
	  a=a_disp[0]+a_disp[1]/(a_disp[2]-s^2)+a_disp[3]/(a_disp[4]-s^2)
	  a=a/10000.d0	; We want coefficients of similar magnitude
	  b=b_disp[0]+b_disp[1]*s^2
	  for j=0,nbl-1 do begin
	    index=where(VisPhaseErr[i,0:nch-1,j,k] gt 0,count)
	    if count gt 0 then begin
	      se=s[index]
	      ae=a[index]
	      be=b[index]
;	      p=VisPhase(i,index,j,k)+GeoDelay(i,j,k)*se*2*pi_circle
	      p=VisPhase[i,index,j,k]
;	      Note that here wt should NOT be 1/error^2
	      w=1.d0/(VisPhaseErr[i,index,j,k]/(2*pi_circle))
;	      w=1.d0; This could be more stable
	      m[tcount:tcount+count-1,ph]=w
	      sid1=strmid(GenConfig.BaselineId[j,i],0,3)
	      i1=where(GenConfig.StationId eq sid1)
	      m[tcount:tcount+count-1,nph+i1[0]+nsd*0]=w*se
	      m[tcount:tcount+count-1,nph+i1[0]+nsd*1]=w*se*ae
	      m[tcount:tcount+count-1,nph+i1[0]+nsd*2]=w*se*be
	      sid2=strmid(GenConfig.BaselineId[j,i],4,3)
	      i2=where(GenConfig.StationId eq sid2)
	      m[tcount:tcount+count-1,nph+i2[0]+nsd*0]=-w*se
	      m[tcount:tcount+count-1,nph+i2[0]+nsd*1]=-w*se*ae
	      m[tcount:tcount+count-1,nph+i2[0]+nsd*2]=-w*se*be
	      r[tcount:tcount+count-1]=p*w/(2*pi_circle)
	      f[tcount:tcount+count-1]=w/(2*pi_circle)
	      tcount=tcount+count
	    endif
	    ph=ph+1
	  endfor
	endfor
;
	IF tcount GT 0 THEN BEGIN
;
;	No correction; determine group delay only
	if dp eq 1 then begin
		me=m[0:tcount+0,0:nph+nsd*1-1]
		re=r[0:tcount+0]
	fe=f[0:tcount-1]
	for l=0,0 do me[tcount+l,nph+l*nsd]=w_avg	; remove degeneracy d1
	t=transpose(me)
	n=t#me						; normal matrix
	v=t#re						; right hand side
;	Test on singularity
	svd,n,w
	small=where(w lt max(w)*1.0e-8,count)
	if count eq 0 then begin
		in=invert(n,status)
		s=in#v					; direct solution
;		Reconstruct unweighted data and obtain residuals
		re=re[0:tcount-1]/fe
		pe=(me#s) & pe=pe[0:tcount-1]/fe
		std=stddev(sqrt((sin(re)-sin(pe))^2+(cos(re)-cos(pe))^2),mean)
		GrpResidual[0,k]=mean
		GrpResidual[1,k]=std
;		Copy the solution
		GrpDelay[*,k]=s[nph:nph+nsd-1]
		for l=0,nsd-1 do GrpDelayErr[l,k]=sqrt(in[nph+l,nph+l])
;			 	 GrpDelayErr(*,k)=std;	more appropriate?
	endif else ill_condition[k]=k+1
	endif
;
;	Correction with dry air dispersion only
	if dp eq 1 then begin
		me=m[0:tcount+1,0:nph+nsd*2-1]
		re=r[0:tcount+1]
	endif else begin
;		Extract nph more rows to set their values
		me=m[0:tcount+1+nph,0:nph+nsd*2-1]
		re=r[0:tcount+1+nph]
		for l=0,nph-1 do begin
			me[tcount+2+l,l]=w_avg
			re[tcount+2+l]=solutions_in[l,k]*w_avg
		endfor
	endelse
	fe=f[0:tcount-1]
	for l=0,1 do me[tcount+l,nph+l*nsd]=w_avg	; degeneracies d1,a1
	t=transpose(me)
	n=t#me
	v=t#re
	if ill_condition[k] eq 0 then begin
		in=invert(n,status)
		s=in#v
		solutions_out[0:nph+nsd*2-1,k]=s
;		Reconstruct unweighted data and obtain residuals
		re=re[0:tcount-1]/fe
		pe=(me#s) & pe=pe[0:tcount-1]/fe
		std=stddev(sqrt((sin(re)-sin(pe))^2+(cos(re)-cos(pe))^2),mean)
		DryResidual[0,k]=mean
		DryResidual[1,k]=std
;		Copy the solution
		DryDelay[*,k]=s[nph:nph+nsd-1]
		for l=0,nsd-1 do DryDelayErr[l,k]=sqrt(in[nph+l,nph+l])
;			 	 DryDelayErr(*,k)=std;	more appropriate?
	endif
;
;      	Correction including water vapor, very noisy!
	if dp eq 3 then begin
		me=m[0:tcount+2,*]
		re=r[0:tcount+2]
	fe=f[0:tcount-1]
	for l=0,2 do me[tcount+l,nph+l*nsd]=w_avg	; degeneracies d1,a1,b1
	t=transpose(me)
	n=t#me
	v=t#re
	svdc,n,w,u_array,v_array
	small=where(w lt max(w)*1.0e-8,count)
	if count gt 0 then begin
		w[small]=0
		s=svsol(u_array,w,v_array,v)
		in=n
		um=n*0 & um[indgen(ncol),indgen(ncol)]=1
		for l=0,ncol-1 do in[*,l]=svsol(u_array,w,v_array,um[*,l])
	endif else begin
		in=invert(n,status)
		s=in#v
	endelse
;	Reconstruct unweighted data and obtain residuals
	re=re[0:tcount-1]/fe
	pe=(me#s) & pe=pe[0:tcount-1]/fe
	std=stddev(sqrt((sin(re)-sin(pe))^2+(cos(re)-cos(pe))^2),mean)
	WetResidual[0,k]=mean
	WetResidual[1,k]=std
;	Copy the solution
	WetDelay[*,k]=s[nph:nph+nsd-1]
	for l=0,nsd-1 do WetDelayErr[l,k]=sqrt(in[nph+l,nph+l])
;			 WetDelayErr(*,k)=std;	more appropriate?
	endif
;
	ENDIF
endfor
;
if dw and dp eq 1 then begin
	solutions_in=solutions_out
	solutions_in[0:nph-1,*]= $
		fringeid(solutions_in[0:nph-1,*],Rec0,RecN,pt=pt)
	dp=2
	goto,computation
endif
;
index=where(ill_condition ne 0,count)
if count gt 0 then $
print,'Warning(DISPCORR): matrix ill conditioned for points ', $
	retroparse(ill_condition[index])
;
print,'Finished dispersion correction.'
;
end
