pro dispinit,stars,class=class
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Initialize Grp-, Dry-, and WetDelay for specified stars. Initialize
; pointdata if class='point', or scandata if class='scan'. Default is 'point'.
; Re-allocate delays for class 'point' if number of data points has changed.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common PointData,Rec0,RecN,Iscan,StarId,PointTime, $
        FDLPos,FDLPosErr,MetroPos,MetroPosErr,GeoDelay,GeoDelayErr, $
        DelayJitter,DelayJitterErr,SoftDelay,SoftDelayErr, $
        NATJitter,NATJitterErr,NATCounts,NATCountsErr, $
        GrpDelay,GrpDelayErr,DryDelay,DryDelayErr,WetDelay,WetDelayErr, $
        PhotonRate,PhotonRateErr,VisSq,VisSqErr, $
        ComplexVis,ComplexVisErr,ComplTriple,ComplTripleErr, $
        VisAmp,VisAmpErr,VisPhase,VisPhaseErr, $
        TripleAmp,TripleAmpErr,TriplePhase,TriplePhaseErr
common ScanData,scans,bgscans,bufferinfo,positions,velocities,magnitudes
;
if not keyword_set(class) then class='POINT' else class=strupcase(class)
;
if class eq 'SCAN' or class eq 'ALL' then begin
if n_elements(scans) ne 0 then begin
	scans.grpdelay=scans.fdlpos
	scans.grpdelay[genconfig.refstation-1]=0
	scans.grpdelayerr=scans.fdlposerr
	scans.drydelay=scans.fdlpos
	scans.drydelay[genconfig.refstation-1]=0
	scans.drydelayerr=scans.fdlposerr
	scans.wetdelay=scans.fdlpos
	scans.wetdelay[genconfig.refstation-1]=0
	scans.wetdelayerr=scans.fdlposerr
endif
endif
;
if class eq 'POINT' or class eq 'ALL' then begin
if n_elements(PointTime) eq 0 then begin
	GrpDelay=0
	GrpDelayErr=1
	DryDelay=0
	DryDelayErr=1
	WetDelay=0
	WetDelayErr=1
	print,'Dispersion corrected delays initialized.'
endif else begin
	if n_elements(GrpDelay) ne n_elements(PointTime) then begin
		if checkdata([8]) ne 0 then return
		GrpDelay=fltarr(GenConfig.NumSid,n_elements(PointTime))
		DryDelay=fltarr(GenConfig.NumSid,n_elements(PointTime))
		WetDelay=fltarr(GenConfig.NumSid,n_elements(PointTime))
		GrpDelayErr=fltarr(GenConfig.NumSid,n_elements(PointTime))+1
		DryDelayErr=fltarr(GenConfig.NumSid,n_elements(PointTime))+1
		WetDelayErr=fltarr(GenConfig.NumSid,n_elements(PointTime))+1
		print,'Dispersion corrected delays initialized.'
	endif else begin
		if n_elements(stars) eq 0 then list_stars,stars
		for i=0,n_elements(stars)-1 do begin
			for j=0,n_elements(StarId)-1 do begin
				if StarId[j] eq stars[i] then begin
					GrpDelay[*,Rec0[j]:RecN[j]]=0
					DryDelay[*,Rec0[j]:RecN[j]]=0
					WetDelay[*,Rec0[j]:RecN[j]]=0
					GrpDelayErr[*,Rec0[j]:RecN[j]]=1
					DryDelayErr[*,Rec0[j]:RecN[j]]=1
					WetDelayErr[*,Rec0[j]:RecN[j]]=1
				endif
			endfor
		endfor
		print,'Dispersion corrected delays initialized for stars: ', $
			stars,'.'
	endelse
endelse
endif
;
end
