pro display_frames,frames,labels
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common PlotImagesLocal,images,ilabels,d_wid
;
images=frames
for j=0,n_elements(frames[0,0,*])-1 do begin
	binsize=max(frames[*,*,j])/100
	binsize=max(frames)/100
	f=histogram(frames[*,*,j],min=0,binsize=binsize)
	tf=total(f)
	i=0
	tfi=0.
	repeat begin
		tfi=tfi+f[i]
		i=i+1
	endrep until tfi/tf gt 0.99
	images[*,*,j]=bytscl(frames[*,*,j],max=i*binsize)
endfor
images=frames	; Comment this line if you want to use the scaling from above
count=n_elements(images[0,0,*])
nx=n_elements(images[*,0,0])
ny=n_elements(images[0,*,0])
;
if n_elements(labels) eq 0 then labels=sindgen(count)
ilabels=labels
;
base_wid=widget_base(/column)
d_wid=widget_draw(base_wid,notify_realize='displayimages_event', $
	event_pro='displayimages_event', $
	scr_xsize=nx,scr_ysize=ny)
i_wid=cw_fslider(base_wid,minimum=1,maximum=count>2,value=1,/drag, $
	title='Index I',xsize=nx,format='(i0)',uvalue='i')
j_wid=cw_fslider(base_wid,minimum=0,maximum=100,value=0,/drag, $
	title='Index J',xsize=nx,format='(i0)',uvalue='j')
widget_control,base_wid,/realize
xmanager,'display_frames',base_wid,/no_block,event_handler='displayimages_event'
;
end
