pro displayframe,c
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display NPOI fringe frames, with the bin axis up and the channels
; to the right. If a single channel is selected, the frames are just
; associated with a virtual channel axis. The number of frames here
; is defined as the number of xy-pixel images which have to be displayed.
; It is equal to the real frame number if the frames are full bin/channel
; frames.
;
; This procedure is thus designed to produce meaningfull frame data
; displays under various selections for the bincounts passed to it.
;
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
;
if n_elements(c) eq 0 then begin
	print,'***Error(DISPLAYFRAMES): frames undefined!'
	return
endif
b=float(reform(c))
r=size(b)
index=where(r[1:r[0]] eq genconfig.numbin,count) & index=index[0]+1
if count eq 0 then begin
	print,'***Error(DISPLAYFRAMES): unknown frame format!'
	return
endif
if index ge 2 then num_spec=r[1] else num_spec=1
if r[0] gt index+1 then num_frame=r[index+2] else num_frame=1
if r[0] eq 1 then num_chan=1 else num_chan=r[index+1]
;
ny=128
nx=max([128,num_chan])
if num_chan eq 1 then nx=ny/2
y=float(indgen(ny)/(ny/genconfig.numbin))
x=float(indgen(nx)/(nx/num_chan))
;b=b/max(b)*255
b=hist_equal(b)
b=reform(b,num_spec,genconfig.numbin,num_chan,num_frame)
;
for i=0,num_spec-1 do begin
;
if !d.window eq -1 or !d.x_size ne nx or !d.y_size ne ny or i ne 0 then begin
	if nx gt 640 then window_slide,xsize=nx,ysize=ny $
		     else window,xsize=nx,ysize=ny,/free
endif
;
for j=0,num_frame-1 do begin
tvscl,transpose(byte(interpolate(reform(b[i,*,*,j],genconfig.numbin,num_chan), $
                                 y,x,/grid)))
wait,0.1
endfor
;
endfor
;
end
