pro displayimage,compress=compress,magnify=magnify,crop=crop,invert=invert
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
; Display a GUI to display PEARL images. Compress (integer > 1)
; will scale (^(1/compress)) the dynamic range, magnify will enlarge the images.
; With crop (>1), a smaller centered area will be displayed.
;
common PearlData,ov,ow,uc,vc,cv,mv,si,bi,ci,wl,bw,fl,db,cb,dm,rm,cm,cc,rt,rg,rf
common ChannelImage,channel_images,channel_wavelengths,images_cellsize
;
channel_wavelengths=(findgen(20)*0.1+0.4)*1e-6
;
labels=string(channel_wavelengths*1e6,format='(f6.3)')
;
nx=n_elements(cm.teff[*,0])
ny=n_elements(cm.teff[0,*])
nc=n_elements(channel_wavelengths)
channel_images=fltarr(nx,ny,nc)
for j=0,nc-1 do channel_images[*,*,j]=pearlmap(channel_wavelengths[j])
;
; Find center
nx=n_elements(channel_images[*,0,0])
ny=n_elements(channel_images[0,*,0])
nz=n_elements(channel_images[0,0,*])
index=where(channel_images[*,*,0] eq max(channel_images[*,*,0]))
index=index[0]
i=index mod nx
j=index/nx
i=nx/2	; Let's not try to center on the peak for now...
j=ny/2	; Let's not try to center on the peak for now...
if n_elements(compress) eq 0 then compress=1
if n_elements(magnify) eq 0 then magnify=1 else magnify=fix(magnify > 1)
if n_elements(crop) eq 0 then crop=1 else crop=fix(crop > 1)
if magnify gt crop then crop=magnify
i0=i-(nx/2)/crop > 0
i1=i+(nx/2)/crop < nx
j0=j-(ny/2)/crop > 0
j1=j+(ny/2)/crop < ny
nx=i1-i0+1
ny=j1-j0+1
images=(channel_images[i0:i1,j0:j1,*]>0)^(1./compress)
images=rebin(images,nx*magnify,ny*magnify,nz)
if n_elements(invert) eq 0 then invert=0 else invert=invert gt 0
if invert then images=max(images)-images
display_images,images,labels
;
end
