pro disptest,baseline,cohint
COMPILE_OPT STRICTARR,STRICTARRSUBS
;
common StarBase,StarTable,Notes
common SysConfig,SystemId,Date,MetroConfig,GenConfig,GeoParms,GenInfo,GeoInfo
common RawData,TimeStamp,LaserPos,GeoPos,QuadCounts, $
	Raw0,RawN,OutputBeam,BinCounts
;
if n_elements(cohint) eq 0 then cohint=100
;
f=fdldelay(baseline)
t=nint(timestamp-timestamp[0])/1000.
time=add(t,cohint)/cohint
fdl=add(f,cohint)*1e4
;
ch=[0,1,2,3,4,5,6,7,8,9,11,12,13,14,15,16,17,18,19]
l=genconfig.wavelength[ch,outputbeam-1]
v=fringevis(bincounts[*,ch,*])
a=total(abs(v),2) & a=a/max(a) & p2d=(total(a*l)/total(a))/(2*!pi)
d=gitter(41,-4e-6)
;
g=groupdelay(visdft(v,l,d),l,d)
r=visrotate(v,l,g)
vis=add(r,cohint,1)
solve,vis,l,sg
;
p=cphase(visdft(v,l,g))
s=f-smooth(f,100,/edge_truncate)
g1=s+groupdelay(box(abs(visdft(visrotate(v,l,s),l,d)),10,1),l,d) $
    +phaseshift(f,l)*p2d
;g1=s+groupdelay(box(abs(visdft(visrotate(v,l,s),l,d)),10,1),l,d) $
;    +phaseshift(f-groupshift(c1,l),l)*p2d
p1=cphase(total(visrotate(v,l,g1),1))
c1=phasescan(t,p1)
g2=g1-c1*p2d
p2=cphase(total(visrotate(v,l,g2),1))
;
!p.charsize=3
window_slide,xsize=20000,ysize=800
!p.multi=[0,1,3]
!p.psym=3
!y.range=[-4e-6,4e-6]
plot,t,g,ytitle='Group delay [m]'
plot,t,g-p*p2d,ytitle='Group + phase delay [m]'
plot,t,g-p*p2d,ytitle='Enh. group + phase delay [m]'
oplot,t,g2-p2*p2d,psym=3,color=tci(7)
;
solve,add(visrotate(v,l,g),cohint,1),l,sg
solve,add(visrotate(v,l,g1),cohint,1),l,sg1
;v=fringevis(bincounts,1)
;del=fringedelay(v,f,channels=ch+1)
;solve,add(visrotate(v(ch,*),l,del),cohint,1),l,sp1,/pt
solve,add(visrotate(v,l,g2-p2*p2d),cohint,1),l,sp1,/pt
;
!p.charsize=2
window,/free,ysize=800
!x.ticks=0
!y.ticklen=0
!p.multi=[0,1,4]
!x.title='Time [s]'
!y.title='Residual corrected delay [mu]'
!y.range=[-40,40]
;
!p.title='One-color delay on '+baseline
y=polyres(time,fdl,2)
!p.charsize=2
plot,time,y
!p.charsize=1
xyouts,5,-15,'RMS = '+string(stddev(fdl),format='(f4.1)')
;
!p.title='Group delay tracking on '+baseline
y=polyres(time,fdl+sg[0,*],2)
index=where(abs(y) lt 40,count)
!p.charsize=2
plot,time[index],y[index]
!p.charsize=1
xyouts,5,-25,'RMS = '+string(stddev(y[index]),format='(f4.1)')
xyouts,40,-25,'Flagged '+string(n_elements(y)-count)+' samples'
;
!p.title='Enhanced group delay tracking on '+baseline
y=polyres(time,fdl+sg1[0,*],2)
index=where(abs(y) lt 40,count)
!p.charsize=2
plot,time[index],y[index]
!p.charsize=1
xyouts,5,-25,'RMS = '+string(stddev(y[index]),format='(f4.1)')
xyouts,40,-25,'Flagged '+string(n_elements(y)-count)+' samples'
;
!p.title='Phase tracking on '+baseline
y=polyres(time,fdl+sp1[0,*],2)
index=where(abs(y) lt 40,count)
!p.charsize=2
plot,time[index],y[index]
!p.charsize=1
xyouts,5,-25,'RMS = '+string(stddev(y[index]),format='(f4.1)')
xyouts,40,-25,'Flagged '+string(n_elements(y)-count)+' samples'
;...............................................................................
;
window,/free
!p.multi=[0,1,3]
!x.title='Interval'
!y.title='Fringe ID'
!y.range=[-4,4]
!p.title='Group delay tracking on '+baseline
plot,sg[2,*],psym=3
!p.title='Enhanced group delay tracking on '+baseline
plot,sg1[2,*],psym=3
!p.title='Phase tracking on '+baseline
plot,sp1[2,*],psym=3
;
;...............................................................................
;
window,/free
!p.multi=[0,1,2]
num=1
index=lindgen(n_elements(t)/num)*num
plot,t[index],p1[index],title='Residual phase on '+baseline,yrange=[-3,3], $
	xtitle='Time [s]',ytitle='[radians]'
plot,t[index],p2[index],title='Corrected phase on '+baseline,yrange=[-3,3], $
	xtitle='Time [s]',ytitle='[radians]'
;
end
